/*
 * $Id: sig_ps2.c,v 1.17 2009-05-21 16:38:08 vrsieh Exp $
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "fixme.h"

#include "sig_boolean.h"
#include "sig_ps2.h"

int
sig_ps2_send(struct sig_ps2_main *b, void *s, uint8_t byte)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == sizeof(b->member) / sizeof(b->member[0])) {
			return 1;
		}
		if (b->member[nr].s == s) {
			/* Don't send to myself. */
			continue;
		}
		(b->member[nr].f->recv)(b->member[nr].s, byte);
		return 0;
	}
}

int
sig_ps2_clkrunning(struct sig_ps2_main *b, void *s, unsigned int val)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == sizeof(b->member) / sizeof(b->member[0])) {
			return 1;
		}
		if (b->member[nr].s == s) {
			/* Don't send to myself. */
			continue;
		}
		(b->member[nr].f->clkrunning)(b->member[nr].s, val);
		return 0;
	}
}

void
sig_ps2_main_connect(
	struct sig_ps2_main *b,
	void *s,
	const struct sig_ps2_main_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_PS2_MAIN);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

static void
sig_ps2_main_s0_recv(void *_f, uint8_t byte)
{
	struct sig_ps2_main_merge *f = _f;

	sig_ps2_send(f->s1, f, byte);
}

static void
sig_ps2_main_s0_clkrunning(void *_f, int val)
{
	struct sig_ps2_main_merge *f = _f;

	sig_ps2_clkrunning(f->s1, f, val);
}

static void
sig_ps2_main_s1_recv(void *_f, uint8_t byte)
{
	struct sig_ps2_main_merge *f = _f;

	sig_ps2_send(f->s0, f, byte);
}

static void
sig_ps2_main_s1_clkrunning(void *_f, int val)
{
	struct sig_ps2_main_merge *f = _f;

	sig_ps2_clkrunning(f->s0, f, val);
}

struct sig_ps2_main_merge *
sig_ps2_main_merge(struct sig_ps2_main *s0, struct sig_ps2_main *s1)
{
	static const struct sig_ps2_main_funcs s0_funcs = {
		.recv = sig_ps2_main_s0_recv,
		.clkrunning = sig_ps2_main_s0_clkrunning,
	};
	static const struct sig_ps2_main_funcs s1_funcs = {
		.recv = sig_ps2_main_s1_recv,
		.clkrunning = sig_ps2_main_s1_clkrunning,
	};
	struct sig_ps2_main_merge *m;

	m = malloc(sizeof(*m));
	assert(m);

	m->s0 = s0;
	sig_ps2_main_connect(s0, m, &s0_funcs);
	m->s1 = s1;
	sig_ps2_main_connect(s1, m, &s1_funcs);

	return m;
}

void
sig_ps2_main_split(struct sig_ps2_main_merge *m)
{
	fixme();
}

struct sig_ps2_main *
sig_ps2_main_create(const char *name)
{
	struct sig_ps2_main *sig;

	sig = malloc(sizeof(*sig));

	sig->type = SIG_GEN_PS2_MAIN;
	sig->nmembers = 0;

	return sig;
}

void
sig_ps2_main_destroy(struct sig_ps2_main *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_PS2_MAIN);

	free(sig);
}

struct sig_ps2 *
sig_ps2_create(const char *name)
{
	struct sig_ps2 *c;
	char n[1000];

	c = malloc(sizeof(*c));
	assert(c);

	c->type = SIG_GEN_PS2;

	sprintf(n, "%s-+5V", name);
	c->p5V = sig_boolean_create(n);
	sprintf(n, "%s-main", name);
	c->main = sig_ps2_main_create(n);

	return c;
}

void
sig_ps2_destroy(struct sig_ps2 *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_PS2);

	sig_boolean_destroy(sig->p5V);
	sig_ps2_main_destroy(sig->main);

	free(sig);
}
