/*
 * Copyright (C) 2003-2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DEBUG_MESSAGES	0

#ifdef INCLUDE

#if defined(OPENBSD) || defined(DARWIN)
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <net/if.h>
#include <termios.h>
/*
 * IEEE 802.3 Ethernet magic constants.  The frame sizes omit the preamble
 * and FCS/CRC (frame check sequence).
 * Taken from Linux /usr/include/linux/if_ether.h
 */
#define ETH_ALEN	6		/* Octets in one ethernet addr   */
#define ETH_HLEN	14		/* Total octets in header.       */
#define ETH_FRAME_LEN	1514		/* Max. octets in frame sans FCS */

#else
#include <net/ethernet.h>
#endif
#include <arpa/inet.h>

#endif /* INCLUDE */

#ifdef STATE

struct {
	uint8_t mac[6];
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(dump)(
	struct cpssp *cpssp,
	const char *func,
	const unsigned char *buf,
	unsigned int len
)
{
	int i;

	fprintf(stderr, "%s:\n", func);

	/* Print header. */
	fprintf(stderr, "dst:");
	for (i = 0; i < 6; i++) {
		fprintf(stderr, " %02x", *buf++);
	}
	fprintf(stderr, "\n");
	fprintf(stderr, "src:");
	for (i = 0; i < 6; i++) {
		fprintf(stderr, " %02x", *buf++);
	}
	fprintf(stderr, "\n");
	fprintf(stderr, "type:");
	switch (ntohs(*(short *) buf)) {
	case 0x0800: fprintf(stderr, " IP"); break;
	case 0x0806: fprintf(stderr, " ARP"); break;
	case 0x8035: fprintf(stderr, " RARP"); break;
	case 0x86dd: fprintf(stderr, " IPV6"); break;
	default: break;
	}
	fprintf(stderr, " (%04x)", ntohs(*(short *) buf));
	buf += 2;
	fprintf(stderr, "\n");

	/* Print payload. */
	for (i = 0; i < len; i++) {
		fprintf(stderr, " %02x", buf[i]);
		if (i % 16 == 15) {
			fprintf(stderr, "\n");
		}
	}
	if (i % 16 != 0) {
		fprintf(stderr, "\n");
	}
}

static void
NAME_(from_net)(struct cpssp *cpssp, const unsigned char *buf, unsigned int len)
{
	static const uint8_t broadcast[6] = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff
	};
	const struct ether_header *hdr = (const struct ether_header *) buf;

	if (DEBUG_MESSAGES) {
		NAME_(dump)(cpssp, __FUNCTION__, buf, len);
	}

	if (memcmp(hdr->ether_dhost, broadcast, ETH_ALEN) != 0
	 && memcmp(hdr->ether_dhost, cpssp->NAME.mac, ETH_ALEN) != 0) {
		/* Message not for us... */
		fprintf(stderr, "Dropping message for %02x:%02x:%02x:%02x:%02x:%02x.\n",
			hdr->ether_dhost[0], hdr->ether_dhost[1],
			hdr->ether_dhost[2], hdr->ether_dhost[3],
			hdr->ether_dhost[4], hdr->ether_dhost[5]);
		return;
	}

	NAME_(to_arp)(cpssp, buf, len);
}

static void
NAME_(from_arp)(struct cpssp *cpssp, const unsigned char *buf, int len)
{
	if (DEBUG_MESSAGES) {
		NAME_(dump)(cpssp, __FUNCTION__, buf, len);
	}

	NAME_(to_net)(cpssp, buf, len);
}

static void
NAME_(create)(struct cpssp *cpssp, const uint8_t *mac)
{
	memcpy(cpssp->NAME.mac, mac, sizeof(cpssp->NAME.mac));
}

static void
NAME_(destroy)(void *cpssp)
{
}

#endif /* BEHAVIOR */
