#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1993, 1994, 1998 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: shell script to generate the MANIFEST file
#
case $# in
2)
	;;
*)
	echo "Usage: $0 <filename> [resolve <filename> ]" 1>&2
	exit 1
	;;
esac
fn=$1
rfn=$2
case $fn in
MANIFEST)
	info="This file"
	;;
LICENSE)
	info="GNU General Public License"
	;;
README)
	info="Blurb about fhist"
	;;
BUILDING)
	info="Instructions how to build, test and install fhist"
	;;
etc/CHANGES.*.*)
	info="Change history of fhist"
	;;
etc/config.h.in*)
	info="input to autoheader, to construct common/config.h.in"
	;;
etc/template/*)
	info="new file initial contents template"
	;;
common/config.h.in)
	info="input to configure, template for common/config.h"
	;;
common/patchlevel.h)
	info="The patch level of this distribution."
	;;
configure)
	info="shell script to configure fhist"
	;;
etc/version.so)
	info="roff include file containing release number"
	;;
*)
	info=`awk '
/[ 	]MANIFEST:[ 	]/ {
for (j = 1; j < NF; ++j)
	if ($j == "MANIFEST:")
		break;
for (k = j + 1; k <= NF; ++k)
	printf(" %s", $k);
printf("\n");
exit;
}' $rfn`
	;;
esac
echo "$fn	$info"
exit 0
