/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: AboutDialog.cc,v 1.3 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "AboutDialog.hh"

#include "fwbuilder/Constants.hh"
#include "helpers.hh"
#include "PixmapButton.hh"

using namespace libfwbuilder;



AboutDialog::AboutDialog()
{
    about_dlg=this;
    about_dlg->set_name("about");
    delete_event.connect(SigC::slot(this,&AboutDialog::on_delete));

    string s=title->get_text();
    s=s+VERSION;
    title->set_text(s);

    widgetModifyFont(title,
		     "-*-helvetica-bold-o-*-*-18-*-*-*-*-*-*-*");

    s=using_libfwbuilder->get_text();
    s=s+Constants::getLibraryVersion();
    using_libfwbuilder->set_text(s);

    PixmapButton::addPixmapAndText( *ok_button , "Ok"     , "OK"     );
    
    ok_button->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    ok_button->grab_focus();
    ok_button->grab_default();

//    set_usize(400,300);
}

AboutDialog*   AboutDialog::about_dlg=NULL;

void AboutDialog::showAboutDialog()
{
    if (about_dlg==NULL) {
	about_dlg=new AboutDialog();
	about_dlg->show_all();
    }
}

gint AboutDialog::on_delete(GdkEventAny* ev)
{   
    destroy();
    about_dlg=NULL;
    return false;
}

void AboutDialog::on_ok_clicked()
{   
    destroy();
    about_dlg=NULL;
}
