/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP65Dialog.hh,v 1.14 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _DISCOVERYDRUIDP65DIALOG_HH
#  include "DiscoveryDruidP65Dialog_glade.hh"
#  define _DISCOVERYDRUIDP65DIALOG_HH
#include "glademm_support.hh"

#include "BackgroundOpWidget.hh"
#include "fwbuilder/IPAddress.hh"
#include "fwbuilder/snmp.hh"
#include "ObjectDescriptor.hh"

class DiscoveryDruidP65Dialog : public DiscoveryDruidP65Dialog_glade
{   
        
        friend class DiscoveryDruidP65Dialog_glade;

    bool                     data_ready;

    BackgroundOpWidget          *bow;

#ifdef HAVE_LIBSNMP
    libfwbuilder::SNMPCrawler                 *q;
#endif

    SigC::Connection                   completed_conn;

    vector<ObjectDescriptor>           crawlerHosts;
    vector<libfwbuilder::IPNetwork>    crawlerNets;

    int  on_completed(int arg);
    void on_save_to_file_clicked();

    public:

    DiscoveryDruidP65Dialog();
    ~DiscoveryDruidP65Dialog();

    void execute(libfwbuilder::IPAddress seed_addr,
		 const string& snmp_community,
		 bool  recursive,
		 bool  include_virtual,
		 bool  do_dns,
		 bool  follow_p2p,
		 int   snmp_retries, int snmp_timeout,
		 int   dns_retries , int dns_timeout, int   dns_threads,
		 vector<libfwbuilder::IPNetwork> *include);

    void stop_operation();
    bool ready();

    const vector<ObjectDescriptor>&         getHosts()    {  return crawlerHosts; }
    const vector<libfwbuilder::IPNetwork>&  getNetworks() {  return crawlerNets;  }


};
#endif
