/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWObjectDialog.cc,v 1.11 2001/12/27 06:48:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "FWObjectDialog.hh"

#include "main_window.hh"

#include <gtk--.h>

using namespace libfwbuilder;

FWObjectDialog::FWObjectDialog(FWObject *obj) 
{ 
    object=obj; 

    attr_list->column(0).set_auto_resize(true);
    attr_list->column(0).set_justification(GTK_JUSTIFY_LEFT);

    attr_list->column(1).set_auto_resize(true);
    attr_list->column(1).set_justification(GTK_JUSTIFY_LEFT);

}

void FWObjectDialog::wrk2dlg()
{
    name->set_text(object->getName());
    name->set_editable( ! Resources::isSystem(object) );

    type_name->set_text(object->getTypeName());

    gint  row=0;
    char *crow[3]={"","",""};

    map<string, string>::iterator d;
    for(d=object->dataBegin(); d!=object->dataEnd(); ++d) 
    {
	attr_list->append( (const char**)crow );
        
	attr_list->cell(row,0).set_spacing(10);
	attr_list->cell(row,0).set_text((*d).first);
			      
	attr_list->cell(row,1).set_spacing(10);
	attr_list->cell(row,1).set_text((*d).second);

	++row;
    }
}

bool FWObjectDialog::dlg2wrk()
{
    return(false);
}

void FWObjectDialog::on_new_clicked()
{   
}

void FWObjectDialog::on_edit_clicked()
{   
}

void FWObjectDialog::on_del_clicked()
{   
}


