/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PolicyDialog.hh,v 1.8 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _PolicyDialog_HH
#  include "PolicyDialog_glade.hh"
#  define _PolicyDialog_HH
#include "glademm_support.hh"

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Policy.hh"
#include "PolicyList.hh"

class PolicyDialog : public PolicyDialog_glade
{   
        
  friend class PolicyDialog_glade;

  void on_policy_line_add();
  void on_policy_line_remove();
/*
  void on_insert_top();
  void on_append_bottom();
  void on_add_rule();
  void on_remove_rule();
  void on_move_up();
  void on_move_down();
*/

  void on_open_item(void *arg);

  libfwbuilder::Policy      *working_copy;

  PolicyList                 *policylist_ptr;

public:

  PolicyDialog(libfwbuilder::FWObject *obj);
  ~PolicyDialog();

  virtual void wrk2dlg();
  virtual bool dlg2wrk();

//  void insertRuleBefore(gint row_n=-1);
//  void appendRuleAfter(gint row_n=-1);
//  void delRule(gint row_n=-1);

    PolicyList* getPolicyList() { return policylist_ptr; }

    virtual void updateMainMenu();
};
#endif
