
%define name    fwbuilder
%define version 2.0.9
%define release 1


%if "%_vendor" == "MandrakeSoft"
%define guigroup  System/Configuration/Networking
%define compgroup System/Configuration/Networking
%else
%define guigroup  Applications/System
%define compgroup Applications/System
%endif

Summary:        Firewall Builder
Name:           %{name}
Version:        %{version}
Release:        %{release}
License:        GPL2
Group:          %{guigroup}
Url:            http://www.fwbuilder.org/
Source:         http://prdownloads.sourceforge.net/fwbuilder/%{name}-%{version}.tar.gz
Packager:       Vadim Kurland <vadim@fwbuilder.org>

Buildroot:      %{_tmppath}/%{name}-%{version}-root

Requires:      libfwbuilder = 2.0.9
BuildRequires: libfwbuilder-devel = 2.0.9
%if "%_vendor" == "redhat"
BuildRequires: qt-devel
%else
BuildRequires: qt3-devel
%endif

Docdir:         /usr/share/doc

%description
Firewall Builder consists of a GUI and set of policy compilers for
various firewall platforms. It helps users maintain a database of
objects and allows policy editing using simple drag-and-drop
operations. GUI generates firewall description in the form of XML
file, which compilers then interpret and generate platform-specific
code. Several algorithms are provided for automated network objects
discovery and bulk import of data. The GUI and policy compilers are
completely independent, this provides for a consistent abstract model
and the same GUI for different firewall platforms. 

%prep

%setup 

%build
./configure --prefix=/usr/ --with-templatedir=/usr/share/fwbuilder
make QTDIR=`cat qtdir` all

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make QTDIR=`cat qtdir` DDIR="${RPM_BUILD_ROOT}/" install
rm -fr $RPM_BUILD_ROOT/usr/share/doc/%{name}-%{version}

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT


# /usr/share/locale/*/*/*
# /usr/bin/fwb_compile_all

%files
%defattr(-,root,root)
%dir /usr/share/fwbuilder
/usr/share/fwbuilder/locale/*
/usr/share/fwbuilder/platform/*
/usr/share/fwbuilder/os/*
/usr/share/fwbuilder/resources.xml
/usr/share/fwbuilder/objects_init.xml
/usr/share/fwbuilder/templates.xml
/usr/bin/fwbuilder
/usr/bin/fwblookup
/usr/bin/fwbedit
/usr/bin/fwb_install
/usr/bin/fwb_compile_all
%doc doc/AUTHORS
%doc doc/COPYING
%doc doc/Credits
%doc doc/ChangeLog
%doc doc/PatchAcceptancePolicy.txt
%doc doc/README.floppyfw
%doc doc/README.ipf
%doc doc/README.ipfw
%doc doc/README.ipt
%doc doc/README.pf
%doc doc/ReleaseNotes_2_0.html
%doc doc/ReleaseNotes_2_0.txt
%doc doc/ReleaseNotes_2.0.1.html
%doc doc/ReleaseNotes_2.0.1.txt
%doc doc/ReleaseNotes_2.0.2.html
%doc doc/ReleaseNotes_2.0.2.txt
%doc doc/ReleaseNotes_2.0.3.html
%doc doc/ReleaseNotes_2.0.3.txt
%doc doc/ReleaseNotes_2.0.4.html
%doc doc/ReleaseNotes_2.0.4.txt
%doc doc/ReleaseNotes_2.0.5.html
%doc doc/ReleaseNotes_2.0.5.txt
%doc doc/ReleaseNotes_2.0.6.html
%doc doc/ReleaseNotes_2.0.6.txt
%doc doc/ReleaseNotes_2.0.7.html
%doc doc/ReleaseNotes_2.0.7.txt
%doc doc/ReleaseNotes_2.0.8.html
%doc doc/ReleaseNotes_2.0.8.txt
%{_mandir}/man1/fwbuilder.1*
%{_mandir}/man1/fwblookup.1*
%{_mandir}/man1/fwbedit.1*
%{_mandir}/man1/fwb_install.1*
%{_mandir}/man1/fwb_compile_all.1*
%{_mandir}/man1/fwb_ipf.1*
%{_mandir}/man1/fwb_ipfw.1*
%{_mandir}/man1/fwb_pf.1*


%package pf
Summary: policy compiler for OpenBSD pf
Group:          %{compgroup}

%description pf
Policy compiler for OpenBSD PF

%files pf
%defattr(-,root,root)
/usr/bin/fwb_pf
%doc doc/AUTHORS
%doc doc/COPYING
%doc doc/Credits
%doc doc/README.pf
%{_mandir}/man1/fwb_pf.1*


%package ipf
Summary: policy compiler for ipfilter
Group:          %{compgroup}

%description ipf
Policy compiler for ipfilter

%files ipf
%defattr(-,root,root)
/usr/bin/fwb_ipf
%doc doc/AUTHORS
%doc doc/COPYING
%doc doc/Credits
%doc doc/README.ipf
%{_mandir}/man1/fwb_ipf.1*


%package ipfw
Summary: policy compiler for ipfw
Group:          %{compgroup}

%description ipfw
Policy compiler for ipfw

%files ipfw
%defattr(-,root,root)
/usr/bin/fwb_ipfw
%doc doc/AUTHORS
%doc doc/COPYING
%doc doc/Credits
%doc doc/README.ipfw
%{_mandir}/man1/fwb_ipfw.1*


%package ipt
Summary: policy compiler for iptables
Group:          %{compgroup}

%description ipt
Policy compiler for iptables

%files ipt
%defattr(-,root,root)
/usr/bin/fwb_ipt
%doc doc/AUTHORS
%doc doc/COPYING
%doc doc/Credits
%doc doc/README.ipt
%{_mandir}/man1/fwb_ipt.1*


