/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: pixosAdvancedDialog.cpp,v 1.2 2004/03/21 23:46:20 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"
#include "global.h"
#include "utils.h"

#include "pixosAdvancedDialog.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Management.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qregexp.h>


using namespace std;
using namespace libfwbuilder;


pixosAdvancedDialog::pixosAdvancedDialog(QWidget *parent,FWObject *o)
    : pixosAdvancedDialog_q(parent)
{
    obj=o;

    FWOptions *fwoptions=(Firewall::cast(obj))->getOptionsObject();
    assert(fwoptions!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

/* Page "General" */
    data.registerOption( pix_set_host_name  , fwoptions,  "pix_set_host_name" );
    data.registerOption( pix_ip_address  ,    fwoptions,  "pix_ip_address"    );

/* Page NTP */

    data.registerOption( ntp1,       fwoptions,  "pix_ntp1"        );
    data.registerOption( ntp1_pref,  fwoptions,  "pix_ntp1_pref"   );
    data.registerOption( ntp2,       fwoptions,  "pix_ntp2"        );
    data.registerOption( ntp2_pref,  fwoptions,  "pix_ntp2_pref"   );
    data.registerOption( ntp3,       fwoptions,  "pix_ntp3"        );
    data.registerOption( ntp3_pref,  fwoptions,  "pix_ntp3_pref"   );

/* Page SNMP */

    data.registerOption( disable_snmp_agent, fwoptions,  "pix_disable_snmp_agent");

    data.registerOption( set_communities,    fwoptions,  "pix_set_communities_from_object_data" );
    data.registerOption( enable_traps,       fwoptions,  "pix_enable_snmp_traps"                );

    data.registerOption( snmp_server1,       fwoptions,  "pix_snmp_server1"                     );
    data.registerOption( snmp_server2,       fwoptions,  "pix_snmp_server2"                     );

    data.registerOption( snmp_poll_traps_1,  fwoptions,  "pix_snmp_poll_traps_1"                );
    data.registerOption( snmp_poll_traps_2,  fwoptions,  "pix_snmp_poll_traps_2"                );

/* Page Options */

    data.registerOption( tcpmss,             fwoptions,  "pix_tcpmss");
    data.registerOption( tcpmss_value,       fwoptions,  "pix_tcpmss_value");

    data.loadAll();
}

/*
 * store all data in the object
 */
void pixosAdvancedDialog::accept()
{
    data.saveAll();
    pixosAdvancedDialog_q::accept();
}

void pixosAdvancedDialog::reject()
{
    pixosAdvancedDialog_q::reject();
}


