/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: FilterDialog.cpp,v 1.8 2006/05/15 04:26:33 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"

#include "FilterDialog.h"
#include "DiscoveryDruid.h"
#include "ObjectManipulator.h"
#include "FWBSettings.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/Interface.h"
#include "fwbuilder/FWException.h"
#include "fwbuilder/Rule.h"
#include "fwbuilder/Firewall.h"
#include "fwbuilder/XMLTools.h"


#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qbuttongroup.h> 
#include <qradiobutton.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qwidgetstack.h>
#include <qcursor.h>
#include <qregexp.h>
#include <qtable.h>
#include <qmessagebox.h> 

#include <iostream>
#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;


void FilterDialog::setFilter(Filter * f)
{
    flt=f;

    /*
    QString p_n;
    QString p_a;
    int f_a,f_n,f_w,f_c;
    
    f_w=flt->isWildcard();
    f_c=flt->isCaseSens();
    f_a=flt->flt_addr;
    f_n=flt->flt_name;
    p_a=flt->getAddrPattern();
    p_n=flt->getNamePattern();
    
    init(f_w,f_c,f_a,f_n,p_a,p_n);
      */ 
    //table->setColumnStretchable(2,true);
    table->setColumnStretchable(2,true);
}
void FilterDialog::apply()
{
    updateData();
    if (validate())
    {
        update();
        accept();
    }
    else
    {
        QMessageBox::critical(this,tr("Filter error"),tr("Invalid RegExp.") );
    }
}

void  FilterDialog::save()
{
    QString dir;
    if (LastFile.isEmpty())
    {
        dir=st->getWDir();
        if (dir.isEmpty())  dir=st->getOpenFileDir();
        if (dir.isEmpty())  dir="~";
    }
    else
    {
        dir=LastFile;
    }
    QString s = QFileDialog::getSaveFileName(
                    dir,
                    "FWBuilder filter files (*.fwf)",
                    this,
                    "Save file dialog",
                    "Choose a file" );
    
    
    if (!s.isEmpty())
    {
        if (s.findRev(".fwf",-1,false)==-1)
        {
            s+=".fwf";
        }

        xmlDocPtr doc;
        
        xmlNodePtr node;
        //xmlNodePtr tree;
        
        doc = xmlNewDoc(TOXMLCAST("1.0"));
        doc->children = xmlNewDocNode(doc, NULL, TOXMLCAST("FWB_FILTER"), NULL);

        xmlSetProp(doc->children, TOXMLCAST("version"),
                TOXMLCAST( VERSION ));
        xmlSetProp(doc->children, TOXMLCAST("CaseSensitive"),
                TOXMLCAST( ((case_sensitive->isChecked())?"1":"0") ));
        xmlSetProp(doc->children, TOXMLCAST("Match"),
                TOXMLCAST( QString("%1").arg(combo->currentItem()).latin1() ));

        QString buf;
        int n=table->numRows();
        for (int i=0;i<n;i++)
        {
            node = xmlNewChild(doc->children , NULL ,  TOXMLCAST("FWB_FILTER_ITEM"), NULL);

            buf=QString("%1").arg(((QComboTableItem *)table->item(i,0))->currentItem());
            xmlSetProp(node,(const xmlChar*)  "Target",
                    TOXMLCAST(buf.latin1()) );
            
            buf=QString("%1").arg(((QComboTableItem *)table->item(i,1))->currentItem());
            xmlSetProp(node, (const xmlChar*) "Type",
                    TOXMLCAST(buf.latin1()) );
            
            xmlSetProp(node, (const xmlChar*) "Pattern",
                    TOXMLCAST(table->text(i,2).latin1()));
        }

        
        xmlSaveFile(s.latin1(),doc);
        xmlFreeDoc(doc);

    } 
}
void  FilterDialog::load()
{
    QString dir;
    dir=st->getWDir();
    if (dir.isEmpty())  dir=st->getOpenFileDir();
    if (dir.isEmpty())  dir="~";
    
    QString s = QFileDialog::getOpenFileName(
                    dir,
                    "FWBuilder filter files (*.fwf)",
                    this,
                    "Open file dialog",
                    "Choose a file" );
    
    
    if (!s.isEmpty())
    {
        
        xmlDocPtr doc=xmlParseFile(s.latin1());
        //TODO: use local codepage
        if (doc == NULL)
        {
            qDebug("Document not parsed successfully.");
            return;
        }

        xmlNodePtr node= xmlDocGetRootElement(doc);

        if (node == NULL)
        {
            qDebug("empty document");
            xmlFreeDoc(doc);
            return;
        }
        
        if (xmlStrcmp(node->name,(const xmlChar*) "FWB_FILTER"))
        {
            qDebug("document of the wrong type. (FWB_FILTER)");
            xmlFreeDoc(doc);
            return;
        }

        xmlChar *xmlbuf;
        QString qbuf;

        xmlbuf=xmlGetProp(node,(const xmlChar*) "CaseSensitive");
        qbuf=FROMXMLCAST(xmlbuf);
        FREEXMLBUFF(xmlbuf);
        case_sensitive->setChecked(qbuf.toInt());

        xmlbuf=xmlGetProp(node,(const xmlChar*) "Match");
        qbuf=FROMXMLCAST(xmlbuf);
        FREEXMLBUFF(xmlbuf);
        combo->setCurrentItem(qbuf.toInt());
      

        node=node->xmlChildrenNode;
        while (node != NULL)
        {
            if (xmlStrcmp(node->name,(const xmlChar*) "FWB_FILTER_ITEM"))
            {
                qDebug("document of the wrong type. (FWB_FILTER_ITEM)");
                xmlFreeDoc(doc);
                return;
            }
            
            addPattern();
            int n=table->numRows()-1;
            
            
            xmlbuf=xmlGetProp(node,(const xmlChar*) "Target");
            qbuf=FROMXMLCAST(xmlbuf);
            FREEXMLBUFF(xmlbuf);
            ((QComboTableItem *)table->item(n,0))->setCurrentItem(
                       qbuf.toInt());
            
            xmlbuf=xmlGetProp(node,(const xmlChar*) "Type");
            qbuf=FROMXMLCAST(xmlbuf);
            FREEXMLBUFF(xmlbuf);
            ((QComboTableItem *)table->item(n,1))->setCurrentItem(
                       qbuf.toInt());
            

            xmlbuf=xmlGetProp(node,(const xmlChar*) "Pattern");
            qbuf=FROMXMLCAST(xmlbuf);
            FREEXMLBUFF(xmlbuf);
            table->setText(n,2,qbuf);
            
            node=node->next;
        }      
        LastFile=s;
    } 
}

void FilterDialog::update()
{
    QRegExp r;
    Filter newflt;

    newflt.setMatchAny(combo->currentItem());
    newflt.setCaseSens(case_sensitive->isChecked());
    newflt.clear();
    
    int n=table->numRows();
    for(int i=0; i<n;i++)
    {
        r=constructRegExp(i);
        switch (((QComboTableItem *)table->item(i,0))->currentItem())
        {
            case FWF_ADDRESS:
                {
                    newflt.addAddrRegExp(r);
                    break;
                }
            case FWF_NAME:
                {
                    newflt.addNameRegExp(r);
                    break;
                }
            default :
                {
                }
        }
    }
    
    if (newflt.isValid())
    {
        *flt=newflt;
    }
    /*
    bool res=false;
    
    Filter newflt;
    
    newflt.setAddrPattern( addresspattern->text());
    newflt.setNamePattern( namepattern->text());

    newflt.setWildcard( radioButton1->isChecked());
    newflt.setCaseSens( casesens->isChecked());

    newflt.flt_name = name_checkbox->isChecked();
    newflt.flt_addr = addr_checkbox->isChecked();
    
    if (newflt.isValid())
    {
        *flt=newflt;
        res=true;
    }
    
    return res;
    */
}
bool FilterDialog::validate()
{
    bool res=true;
    QRegExp r;

    int n=table->numRows();
    for(int i=0; i<n;i++)
    {
        r=constructRegExp(i);
        if(!r.isValid())
        {
            res=false;
            table->selectRow(i);
            return res;
        }
            
    }
    
    return res;
}
QRegExp FilterDialog::constructRegExp(int p)
{
    QRegExp r;
    QString buf;
    r.setCaseSensitive(case_sensitive->isChecked());
    switch(((QComboTableItem *)table->item(p,1))->currentItem())
    {
        case FWF_CONTAINS: 
            {
                r.setWildcard(true);
                buf=table->text(p,2).latin1();
                break;
            }
        case FWF_IS_EQUAL_TO: 
            {
                r.setWildcard(false);
                buf="^";
                buf+=table->text(p,2).latin1();
                buf+="$";
                break;
            }
        case FWF_STARTS_WITH: 
            {
                r.setWildcard(false);
                buf="^";
                buf+=table->text(p,2).latin1();
                break;
            }
        case FWF_ENDS_WITH: 
            {
                r.setWildcard(false);
                buf=table->text(p,2).latin1();
                buf+="$";
                break;
            }
        case FWF_MATCHES_WILDCARD: 
            {
                r.setWildcard(true);
                buf=table->text(p,2).latin1();
                break;
            }
        case FWF_MATCHES_REGEXP: 
            {
                r.setWildcard(false);
                buf=table->text(p,2).latin1();
                break;
            }
        default :
            {
            }
    }
    r.setPattern(buf);
    return r;
}
void FilterDialog::addPattern()
{
    updateData();
    
    QStringList trg;
    trg+=tr("Name");
    trg+=tr("Address");
    
    QStringList tp;
    tp+=tr("Contains");
    tp+=tr("Is equal to");
    tp+=tr("Starts with");
    tp+=tr("Ends with");
    tp+=tr("Matches Wildcard");
    tp+=tr("Matches RegExp");
    
    int n=table->numRows();
    table->insertRows(n);
    table->setItem(n,0,new QComboTableItem(table,trg));
    table->setItem(n,1,new QComboTableItem(table,tp));
    //table->setItem(n,2,new QTableItem(table,QTableItem::Always));
    table->setItem(n,2,new QTableItem(table,QTableItem::WhenCurrent,""));
}
void FilterDialog::removePattern()
{
    int r=table->currentRow();
    table->removeRow(r);
}
void FilterDialog::clearPatterns()
{
    table->setNumRows(0);
//    for (int i=table->numRows()-1;i>0;i--)
//        table->removeRow(i);
}
void FilterDialog::updateData()
{
    int row=table->currentRow();
    QTableItem * item=table->item(row,2);
    QWidget * w =table->cellWidget (row,2 );
    if (w) item->setContentFromEditor ( w ); 
}
//------------------------------------------------------------------
bool Filter::isCaseSens()
{
    return CaseSensitive;
}
void Filter::addNameRegExp(const QRegExp &r)
{
    name_patterns.push_back(r);
}
void Filter::addAddrRegExp(const QRegExp &r)
{
    addr_patterns.push_back(r);
}
    
QString  Filter::getNamePatternString(int p)
{
    return name_patterns[p].pattern();
}
QString  Filter::getAddrPatternString(int p)
{
    return addr_patterns[p].pattern();
}

int  Filter::getNamePatternsNumber()
{
    return name_patterns.size();
}
int Filter::getAddrPatternsNumber()
{
    return addr_patterns.size();
}

bool Filter::isNameWildcard(int p)
{
    return name_patterns[p].wildcard();
}
bool Filter::isAddrWildcard(int p)
{
    return addr_patterns[p].wildcard();
}

Filter & Filter::operator=(const Filter& f)
{
    addr_patterns=f.addr_patterns;
    name_patterns=f.name_patterns;
    CaseSensitive=f.CaseSensitive;
    MatchAny=f.MatchAny;
    
    return *this;    
}
/*
void FilterDialog::closeEvent(QCloseEvent *e)
{
    if (fwbdebug)
        qDebug("FilterDialog::closeEvent  got close event: %p",e);
    hide();
}
*/

Filter::Filter()
{
    CaseSensitive=true;
    MatchAny=true;
}
Filter::~Filter()
{
}
void Filter::addNamePattern(const QString &s,bool wc)
{
    name_patterns.push_back(QRegExp (s,CaseSensitive,wc));
}
void Filter::addAddrPattern(const QString &s,bool wc)
{
    addr_patterns.push_back(QRegExp (s,CaseSensitive,wc));
}
void Filter::clear()
{
    name_patterns.clear();
    addr_patterns.clear();
}
void Filter::setCaseSens(bool b)
{
    CaseSensitive=b;
}
void Filter::setMatchAny(bool b)
{
    MatchAny=b;
}
bool Filter::isMatchAny ()
{
    return MatchAny;
}
bool Filter::testName(const QString &s)
{
    int cmp;
    if (name_patterns.isEmpty())
    {        
        return addr_patterns.isEmpty() || !MatchAny;
    }
    for (unsigned int i=0;i<name_patterns.size();i++)
    {
        name_patterns[i].setCaseSensitive(CaseSensitive);
        cmp=name_patterns[i].search(s);
        if (MatchAny)
        {
            if(cmp>=0) return true;
        }
        else
        {
            if(cmp<0) return false;
        }
    }
    return !MatchAny;
}
bool Filter::testAddr(const QString &s)
{
    int cmp;
    if (addr_patterns.isEmpty())
    {
        return (name_patterns.isEmpty() || !MatchAny);
    }
    
    for (unsigned int i=0;i<addr_patterns.size();i++)
    {
        addr_patterns[i].setCaseSensitive(CaseSensitive);
        cmp=addr_patterns[i].search(s);
        if (MatchAny)
        {
            if(cmp>=0) return true;
        }
        else
        {
            if(cmp<0) return false;
        }
    }
    return !MatchAny;
}
bool Filter::test(const ObjectDescriptor &od)
{
    QString name=od.sysname.c_str();
    QString addr=od.addr.toString().c_str();
    return (MatchAny)? testAddr(addr) || testName(name):
                       testAddr(addr) && testName(name);
}

bool Filter::isValid()
{
    bool res=true;
    //TODO: Filter validity test
    return res;    
}
