/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: UDPServiceDialog.cpp,v 1.25 2007/04/14 00:18:43 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "UDPServiceDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/UDPService.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

using namespace std;
using namespace libfwbuilder;

void UDPServiceDialog::loadFWObject(FWObject *o)
{
    obj=o;
    UDPService *s = dynamic_cast<UDPService*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    ss->setValue( s->getInt("src_range_start") );
    se->setValue( s->getInt("src_range_end") );
    ds->setValue( s->getInt("dst_range_start") );
    de->setValue( s->getInt("dst_range_end") );

    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    //apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    ss->setEnabled(!o->isReadOnly());
    setDisabledPalette(ss);

    se->setEnabled(!o->isReadOnly());
    setDisabledPalette(se);

    ds->setEnabled(!o->isReadOnly());
    setDisabledPalette(ds);

    de->setEnabled(!o->isReadOnly());
    setDisabledPalette(de);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);


    init=false;
}
    
void UDPServiceDialog::changed()
{
    //apply->setEnabled( true );
    emit changed_sign();
}

void UDPServiceDialog::validate(bool *res)
{
    if (fwbdebug) qDebug("UDPServiceDialog::validate");

    *res=true;

    if (!isTreeReadWrite(this,obj)) { *res=false; return; }
    if (!validateName(this,obj,obj_name->text())) { *res=false; return; }

    // check port ranges (bug #1695481, range start must be <= range end)
    int sps = ss->value();
    int spe = se->value();
    int dps = ds->value();
    int dpe = de->value();

    if (sps > spe)
    {
        QMessageBox::warning(this, "Firewall Builder",
          QObject::tr("Invalid range defined for the source port."),
          QObject::tr("&Continue editing"), NULL, NULL, 0, 2 );
        *res = false;
        return;
    }
    if (dps > dpe)
    {
        QMessageBox::warning(this, "Firewall Builder",
          QObject::tr("Invalid range defined for the destination port."),
          QObject::tr("&Continue editing"), NULL, NULL, 0, 2 );
        *res = false;
        return;
    }
}

void UDPServiceDialog::isChanged(bool *res)
{
    //*res=(!init && apply->isEnabled());
}

void UDPServiceDialog::libChanged()
{
    changed();
}

void UDPServiceDialog::applyChanges()
{
    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );

    if (ss->value()!=0 && se->value()==0) se->setValue( ss->value() );
    if (ds->value()!=0 && de->value()==0) de->setValue( ds->value() );

    obj->setInt("src_range_start", ss->value() );
    obj->setInt("src_range_end",   se->value() );
    obj->setInt("dst_range_start", ds->value() );
    obj->setInt("dst_range_end",   de->value() );

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) && libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    //apply->setEnabled( false );
    om->updateLastModifiedTimestampForAllFirewalls(obj);
}

void UDPServiceDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void UDPServiceDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

