-- |
-- Module:     Control.Wire.Prefab
-- Copyright:  (c) 2011 Ertugrul Soeylemez
-- License:    BSD3
-- Maintainer: Ertugrul Soeylemez <es@ertes.de>
--
-- Convenience module importing all the prefab wires.

module Control.Wire.Prefab
    ( -- * Reexports
      module Control.Wire.Prefab.Accum,
      module Control.Wire.Prefab.Analyze,
      module Control.Wire.Prefab.Calculus,
      module Control.Wire.Prefab.Clock,
      module Control.Wire.Prefab.Event,
      module Control.Wire.Prefab.Execute,
      module Control.Wire.Prefab.Queue,
      module Control.Wire.Prefab.Random,
      module Control.Wire.Prefab.Sample,
      module Control.Wire.Prefab.Simple,
      module Control.Wire.Prefab.Split
    )
    where

import Control.Wire.Prefab.Accum
import Control.Wire.Prefab.Analyze
import Control.Wire.Prefab.Calculus
import Control.Wire.Prefab.Clock
import Control.Wire.Prefab.Event
import Control.Wire.Prefab.Execute
import Control.Wire.Prefab.Queue
import Control.Wire.Prefab.Random
import Control.Wire.Prefab.Sample
import Control.Wire.Prefab.Simple
import Control.Wire.Prefab.Split
