module Hat.Foreign.ForeignPtr
  (ForeignPtr(),gnewForeignPtr,anewForeignPtr,hnewForeignPtr
    ,gaddForeignPtrFinalizer,aaddForeignPtrFinalizer,haddForeignPtrFinalizer
    ,gwithForeignPtr,awithForeignPtr,hwithForeignPtr,gforeignPtrToPtr
    ,aforeignPtrToPtr,hforeignPtrToPtr,gtouchForeignPtr,atouchForeignPtr
    ,htouchForeignPtr,gcastForeignPtr,acastForeignPtr,hcastForeignPtr) where

import qualified Prelude 
import qualified Hat.Hat as T 
import qualified Hat.PreludeBasic 
import Hat.Prelude 
import Hat.PreludeBuiltinTypes 
import Hat.Foreign.BuiltinTypes 
import qualified Foreign.ForeignPtr 

gnewForeignPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun (IO T.Tuple0) (IO (ForeignPtr a))))

gnewForeignPtr pnewForeignPtr p =
  T.ufun2 anewForeignPtr pnewForeignPtr p hnewForeignPtr

hnewForeignPtr z1newForeignPtr z2newForeignPtr knewForeignPtr =
  (T.fromIO (fromForeignPtr T.fromId)) knewForeignPtr
    (Foreign.ForeignPtr.newForeignPtr
      ((toPtr T.toId) knewForeignPtr z1newForeignPtr)
      ((T.toIO T.toTuple0) knewForeignPtr z2newForeignPtr))

gaddForeignPtrFinalizer ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (ForeignPtr a) (T.Fun (IO T.Tuple0) (IO T.Tuple0)))

gaddForeignPtrFinalizer paddForeignPtrFinalizer p =
  T.ufun2 aaddForeignPtrFinalizer paddForeignPtrFinalizer p
    haddForeignPtrFinalizer

haddForeignPtrFinalizer z1addForeignPtrFinalizer z2addForeignPtrFinalizer
  kaddForeignPtrFinalizer =
  (T.fromIO T.fromTuple0) kaddForeignPtrFinalizer
    (Foreign.ForeignPtr.addForeignPtrFinalizer
      ((toForeignPtr T.toId) kaddForeignPtrFinalizer z1addForeignPtrFinalizer)
      ((T.toIO T.toTuple0) kaddForeignPtrFinalizer z2addForeignPtrFinalizer))

gwithForeignPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (ForeignPtr a) (T.Fun (T.Fun (Ptr a) (IO b)) (IO b)))

gwithForeignPtr pwithForeignPtr p =
  T.ufun2 awithForeignPtr pwithForeignPtr p hwithForeignPtr

hwithForeignPtr z1withForeignPtr z2withForeignPtr kwithForeignPtr =
  (T.fromIO T.fromId) kwithForeignPtr
    (Foreign.ForeignPtr.withForeignPtr
      ((toForeignPtr T.toId) kwithForeignPtr z1withForeignPtr)
      ((toFun (fromPtr T.fromId) (T.toIO T.toId)) kwithForeignPtr
        z2withForeignPtr))

gforeignPtrToPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (ForeignPtr a) (Ptr a))

gforeignPtrToPtr pforeignPtrToPtr p =
  T.ufun1 aforeignPtrToPtr pforeignPtrToPtr p hforeignPtrToPtr

hforeignPtrToPtr z1foreignPtrToPtr kforeignPtrToPtr =
  (fromPtr T.fromId) kforeignPtrToPtr
    (Foreign.ForeignPtr.foreignPtrToPtr
      ((toForeignPtr T.toId) kforeignPtrToPtr z1foreignPtrToPtr))

gtouchForeignPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (ForeignPtr a) (IO T.Tuple0))

gtouchForeignPtr ptouchForeignPtr p =
  T.ufun1 atouchForeignPtr ptouchForeignPtr p htouchForeignPtr

htouchForeignPtr z1touchForeignPtr ktouchForeignPtr =
  (T.fromIO T.fromTuple0) ktouchForeignPtr
    (Foreign.ForeignPtr.touchForeignPtr
      ((toForeignPtr T.toId) ktouchForeignPtr z1touchForeignPtr))

gcastForeignPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (ForeignPtr a) (ForeignPtr b))

gcastForeignPtr pcastForeignPtr p =
  T.ufun1 acastForeignPtr pcastForeignPtr p hcastForeignPtr

hcastForeignPtr z1castForeignPtr kcastForeignPtr =
  (fromForeignPtr T.fromId) kcastForeignPtr
    (Foreign.ForeignPtr.castForeignPtr
      ((toForeignPtr T.toId) kcastForeignPtr z1castForeignPtr))

geqForeignPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (ForeignPtr a) (T.Fun (ForeignPtr a) Bool))

geqForeignPtr peqForeignPtr p =
  T.ufun2 aeqForeignPtr peqForeignPtr p heqForeignPtr

heqForeignPtr z1eqForeignPtr z2eqForeignPtr keqForeignPtr =
  fromBool keqForeignPtr
    (((toForeignPtr T.toId) keqForeignPtr z1eqForeignPtr)
      Prelude.==
      ((toForeignPtr T.toId) keqForeignPtr z2eqForeignPtr))

gshowsPrecForeignPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun (ForeignPtr a) (T.Fun String String)))

gshowsPrecForeignPtr pshowsPrecForeignPtr p =
  T.ufun3 ashowsPrecForeignPtr pshowsPrecForeignPtr p hshowsPrecForeignPtr

hshowsPrecForeignPtr z1showsPrecForeignPtr z2showsPrecForeignPtr
  z3showsPrecForeignPtr kshowsPrecForeignPtr =
  fromString kshowsPrecForeignPtr
    (Prelude.showsPrec (T.toInt kshowsPrecForeignPtr z1showsPrecForeignPtr)
      ((toForeignPtr T.toId) kshowsPrecForeignPtr z2showsPrecForeignPtr)
      (toString kshowsPrecForeignPtr z3showsPrecForeignPtr))

instance Eq ((ForeignPtr a))
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) = T.uconstDef T.mkRoot (+%^=&==) (\ p -> geqForeignPtr T.mkNoSrcPos p)
  

instance Show ((ForeignPtr a))
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a41v3showsPrec
      (\ p -> gshowsPrecForeignPtr T.mkNoSrcPos p)
  

tForeign_ForeignPtr =
  T.mkModule "Foreign.ForeignPtr" "Foreign/ForeignPtr.hs" Prelude.False

anewForeignPtr =
  T.mkVariable tForeign_ForeignPtr 160003 3 2 "newForeignPtr" Prelude.False

aaddForeignPtrFinalizer =
  T.mkVariable tForeign_ForeignPtr 180003 3 2 "addForeignPtrFinalizer"
    Prelude.False

awithForeignPtr =
  T.mkVariable tForeign_ForeignPtr 200003 3 2 "withForeignPtr" Prelude.False

aforeignPtrToPtr =
  T.mkVariable tForeign_ForeignPtr 220003 3 1 "foreignPtrToPtr" Prelude.False

atouchForeignPtr =
  T.mkVariable tForeign_ForeignPtr 240003 3 1 "touchForeignPtr" Prelude.False

acastForeignPtr =
  T.mkVariable tForeign_ForeignPtr 260003 3 1 "castForeignPtr" Prelude.False

aeqForeignPtr =
  T.mkVariable tForeign_ForeignPtr 300003 3 2 "eqForeignPtr" Prelude.False

ashowsPrecForeignPtr =
  T.mkVariable tForeign_ForeignPtr 340003 3 3 "showsPrecForeignPtr"
    Prelude.False

(+%^=&==) = T.mkVariable tForeign_ForeignPtr 370004 16 0 "==" Prelude.False

a41v3showsPrec =
  T.mkVariable tForeign_ForeignPtr 410003 3 0 "showsPrec" Prelude.False
