<?php

//    index.php
//    Home page
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: index.php,v 1.16 2002/02/11 08:01:59 angusgb Exp $

include ("./include/global.inc.php");

//
// Show Summary function
// Declaration for PHP3 compatibility
// 

function ShowSummary($dbname, $strSQL, $strHeader)
{
?>

<H4> <?php echo $strHeader; ?> </H4>

<?php

global $MyDB;

$result = $MyDB->CreateHTMLTable($strSQL, $dbname, true);

if ($result<0)
{
   DisplayErrMsg($MyDB->errmsg);
   return;
}
else if (!result):
?>
<P><?php echo $strNoOccurrencies; ?></P>
<?php
endif;
}

if (isset($dbname))
{
   $pagetitle = "Database: $dbname";
   $linkbar = "<A href=\"index.php\">" . $strMainPage . "</A>";
   $linkbar = $linkbar . " | " .
      "<A href=\"drop.php?dbname=" . $dbname . "\">" . $strDBDeletion . "</A>";

}
else
{
   $pagetitle = $strMainPage;
   $linkbar="";

}

?>
<?php include ("./include/header.inc.php"); ?>

<!-- Check the presence of any ht://Check databases -->
<?php

if (! isset($dbname) )
{
   // No database selected

   if (!is_array($dblist) || ! $numdbs=count($dblist))
   {
      if ($MyDB->GetHtCheckDBList())
      {
         DisplayErrMsg($MyDB->errmsg);
         return;
      }

      // Redirect the dinamically created list to the managed one
      $dblist = $MyDB->HtDBs;

      // Set the number of databases
      $numdbs = count ($dblist);

   }

   if ($numdbs)
   {
      if ($numdbs == 1)
         $dbname = $dblist[0];
      else
      {
         // At least one database found
         eval ("\$strNumDBs=\"$strNumDBs\";");
      
?>
<H3><?php echo $strNumDBs; ?></H3>

<?php echo $strChooseaDB; ?>:<BR>
<FORM>
   <SELECT name="dbname">
<?php
         for ($i = 0; $i < $numdbs; $i++)
         {
?>
      <OPTION><?php echo $dblist[$i]; ?></OPTION>
<?php
         }
?>
   </SELECT>
   <INPUT type="submit" value="<?php echo $strSelectaDB; ?>">
</FORM>

<?php
      }
   }
   else
   {
      // No database found
      eval ("\$strNoDBs=\"$strNoDBs\";");
?>
<H3><?php echo $strNoDBs; ?></H3>
<?php
   }
}

if (! empty($dbname) )
{
   // A database has been selected

   eval ("\$strDBSelected=\"$strDBSelected\";");
?>
<?php echo $strDBSelected; ?><BR>

<H3><?php echo $strGeneralInfo; ?>:</H3>
<?php

   $strSQL = "Select * from htCheck";

   // Get general info from htCheck table

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

      $row = $MyDB->FetchArray();
?>

<?php echo $strUser; ?>: <B><?php echo $row["User"]; ?></B><BR>
<?php echo $strStartTime; ?>: <B><?php echo $row["StartTime"]; ?></B><BR>
<?php echo $strEndTime; ?>: <B><?php echo $row["EndTime"]; ?></B><BR>

<?php

   }
   
   $MyDB->Free();


   $result=$MyDB->GetGeneralInfo($dbname);

   if ($result<0)
   {
      DisplayErrMsg($MyDB->errmsg);
      return;
   }
   else
   {
?>

<?php echo $strServersEncountered; ?>: <B><?php echo number_format($MyDB->Info["Server"]); ?></B><BR>
<?php echo $strScheduledURLS; ?>: <B><?php echo number_format($MyDB->Info["Schedule"]); ?></B><BR>

<?php echo $strRetrievedURLS; ?>: <B><?php echo number_format($MyDB->Info["Url"]); ?></B><BR>
<?php echo $strHTMLStatements; ?>: <B><?php echo number_format($MyDB->Info["HtmlStatement"]); ?></B>
   (<?php echo $strHTMLAttributes; ?>: <B><?php echo number_format($MyDB->Info["HtmlAttribute"]); ?></B>)<BR>
<?php echo $strLinks; ?>: <B><?php echo number_format($MyDB->Info["Link"]); ?></B><BR>


<H3><?php echo $strOperations; ?>:</H3>
<MENU>
<LI><A href="qryurls.php?dbname=<?php echo $dbname; ?>"><?php echo $strShowListUrlsFltr; ?></A></LI>
<LI><A href="listlinks.php?dbname=<?php echo $dbname; ?>"><?php echo $strShowListLinks; ?></A></LI>
<LI><A href="listurls.php?dbname=<?php echo $dbname; ?>&all=true"><?php echo $strShowListUrls; ?></A></LI>
<!--
<LI><A href="listurls.php?dbname=<?php echo $dbname; ?>"><?php echo $strShowListUrlsSeen; ?></A></LI>
<LI><A href="listurls.php?dbname=<?php echo $dbname; ?>&StatusCode=404"><?php echo $strShowNotFoundUrls; ?></A></LI>
-->
</MENU>

<?php

   // HTTP results

   $strSQL = "Select StatusCode as '". $strStatusCode . "', ReasonPhrase as '"
      . $strReasonPhrase ."',"
      . " count(*) as '". $strNumber . "' from Url group by StatusCode, ReasonPhrase";

   ShowSummary($dbname, $strSQL, $strHTTPRequestsResults);

   // Servers seen

   $strSQL = "Select Server, Port, HttpServer as '"
      . $strWebServerInfo . "', HttpVersion as '" . $strProtocol . "',"
      . " Requests as '" . $strRequests . "' from Server where Requests > 1"
      . " order by Requests DESC";
   
   ShowSummary($dbname, $strSQL, $strServersSeenOrdIDServer);

   // Connection results

   $strSQL = "Select ConnStatus as '". $strConnectionStatus . "',"
      . " count(*) as 'Num.' from Url group by ConnStatus";
   
   ShowSummary($dbname, $strSQL, $strConnectionResults);

   // Content-Type results

   $strSQL = "Select ContentType as 'Content Type',"
      . " count(*) as '". $strNumber . "' from Url group by ContentType";
   
   ShowSummary($dbname, $strSQL, $strContentTypeResults);

   // Cookies

   $strSQL = "SELECT Name, Value, Path, Domain, SrcUrl as '$strUrl' from Cookies";
   
   ShowSummary($dbname, $strSQL, $strCookiesReport);
   }
}

?>

<BR>

<?php include ("./include/footer.inc.php"); ?>
