/* string.h
 * - Headers for the string functions
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
#ifndef __ICECAST_ICE_STRING_H
#define __ICECAST_ICE_STRING_H

char *splitc(char *first, char *rest, const char divider);
char *clean_string(char *string);
void flags2string(admin_t *adm, void *param);
int is_pattern (const char *string);
int is_number (const char *string);
const char *con_host (connection_t *con);
char *my_strdup (const char *string);
char *util_base64_encode(char *message);
char *util_base64_decode(char *message);
char *safe_strcat (char *dest, const char *src, unsigned int maxsize);
char *mutex_to_string (mutex_t *mutex, char *out);
const char *skip_after (const char *ptr, const char *search);
const char *skip_before (const char *ptr, const char *search);
char *create_malloced_ascii_host(struct in_addr *in);
char *makeasciihost(const struct in_addr *in, char *buf);
char *nice_time(unsigned long int seconds, char *buf);
char *ice_sprintf (const char *template, const char *arg);
int ice_strcasecmp (const char *s1, const char *s2);
int ice_strncmp (const char *s1, const char *s2, size_t n);
int ice_strcmp (const char *s1, const char *s2);
size_t ice_strlen (const char *string);
char *nice_time_minutes (unsigned long int minutes, char *buf);
void catsprintf (char *line, const char *fmt, ...);
const char *nullcheck_string (const char *string);

#endif
