/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IPARTICLEGROUP_H
#define IPARTICLEGROUP_H


#include "isolidviewsubject.h"


class iEventObserver;
class iFunctionMapping;
class iHistogramMaker;
class iParticleConnector;
class iParticlesViewSubject;
class iPiecewiseFunction;

class vtkPolyData;


class iParticleGroup : public iSolidViewSubject
{
	
	friend class iParticleGroupFamily;
	friend class iParticlesViewSubject;

public:
	
	vtkTypeMacro(iParticleGroup,iSolidViewSubject);
	static iParticleGroup* New(iParticlesViewSubject *parent = 0); // needed for creating a special iParticleGroupFamily by iParticlesViewSubject
	static const iObjectType& Type();
		
	IOBJECT_DECLARE_GETSET1(Type,int);
	//void SetType(int t);
	//inline int GetType() const { return mType; }
	
	IOBJECT_DECLARE_GETSET(AttributeToColor,mAttColor,int);
	//void SetAttributeToColor(int a);
	//inline int GetAttributeToColor() const { return mAttColor; }
	
	IOBJECT_DECLARE_GETSET(AttributeToSize,mAttSize,int);
	//void SetAttributeToSize(int a);
	//inline int GetAttributeToSize() const { return mAttSize; }
	
	IOBJECT_DECLARE_GETSET(FixedSize,mSize,float);
	//void SetFixedSize(float s);
	//inline float GetFixedSize() const { return mSize; }
	
	IOBJECT_DECLARE_GETSET1(StretchToColor,int);
	//void SetStretchToColor(int s);
	//inline int GetStretchToColor() const { return mStretchToColor; }
	
	IOBJECT_DECLARE_GETSET(LowerLimitToColor,mLimitsToColor[0],float);
	//void SetLowerLimitToColor(float s);
	//inline float GetLowerLimitToColor() const { return mLimitsToColor[0]; }
	
	IOBJECT_DECLARE_GETSET(UpperLimitToColor,mLimitsToColor[1],float);
	//void SetUpperLimitToColor(float s);
	//inline float GetUpperLimitToColor() const { return mLimitsToColor[1]; }
	
	IOBJECT_DECLARE_GETSET2(StretchToSize,int);
	//void SetStretchToSize(int s);
	//int GetStretchToSize() const;
	
	IOBJECT_DECLARE_GETSET2(LowerLimitToSize,float);
	//void SetLowerLimitToSize(float s);
	//float GetLowerLimitToSize() const;
	
	IOBJECT_DECLARE_GETSET2(UpperLimitToSize,float);
	//void SetUpperLimitToSize(float s);
	//float GetUpperLimitToSize() const;
	
	IOBJECT_DECLARE_GETSET(AttributeSizeDirect,mAttSizeDirect,bool);
	//void SetAttributeSizeDirect(bool s);
	//inline bool GetAttributeSizeDirect() const { return mAttSizeDirect; }
	
	IOBJECT_DECLARE_GETSET(AttributeSizeExtraFactor,mAttSizeExtraFactor,float);
	//void SetAttributeSizeExtraFactor(float f);
	//inline float GetAttributeSizeExtraFactor() const { return mAttSizeExtraFactor; }
	
	IOBJECT_DECLARE_GETSET1(LineWidth,int);
	//void SetLineWidth(int s);
	//inline int GetLineWidth() const { return mLineWidth; }

	IOBJECT_DECLARE_GETSET1(AutoScaled,bool);
	//void SetAutoScaled(bool s);
	//inline bool GetAutoScaled() const { return mAutoScaled; }

	IOBJECT_DECLARE_GETSET2(AttributeToConnect,int);
	//void SetAttributeToConnect(int a);
	//int GetAttributeToConnect() const;
	IOBJECT_DECLARE_GETSET2(AttributeToSeparate,int);
	//void SetAttributeToSeparate(int a);
	//int GetAttributeToSeparate() const;

	IOBJECT_DECLARE_GET2(SizeFunction,iFunctionMapping * );
	//inline iFunctionMapping* GetSizeFunction() const;

	virtual void UpdateColorLookupTable();

	void SetInput(vtkPolyData *input);

	//
	//  Inherited members
	//
	virtual iViewSubjectPipeline* CreatePipeline(int id);
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_KEYS;
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_MEMBERS;

protected:
	
	iParticleGroup(iParticlesViewSubject *parent);
	virtual ~iParticleGroup();
	virtual void ConfigureBody();
	virtual void ConfigureMainPipeline(iViewSubjectPipeline *p, int id);

	virtual void FinishInitialization();
	virtual float GetExtraMemorySize() const;

private:

	iParticlesViewSubject *mParent;
	int mParentIndex;

	int mAttColor, mAttSize;
	bool mAttSizeDirect, mAutoScaled;
	float mAttSizeExtraFactor;
	int mType;
	iPiecewiseFunction *mSF;
	iFunctionMapping *mFunction;
	float mSize;
	int mStretchToColor, mLineWidth;
	float mLimitsToColor[2];

	//
	//  VTK members
	//
	iParticleConnector *mConnector;
	iHistogramMaker *mHistogramMaker;
	iEventObserver *mSizeFunctionEventObserver, *mCameraEventObserver;
};

#endif // IPARTICLEGROUP_H
 
