/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Base class for shell-specific interpreters for ControlScript
//
#ifndef ICOMMANDINTERPRETER_H
#define ICOMMANDINTERPRETER_H


#include <vtkObjectBase.h>


#include "istring.h"

#include "ipointermacro.h"

#include <vtkSetGet.h>

class iControlScript;
class iErrorStatus;
class iShell;


namespace iParameter
{
	namespace CommandInterpreterType
	{
		//
		// CommandInterpreter parameters
		//
		const int Code = 0;
		const int Result = 1;
		const int Error = 2;
	};
};


class iCommandInterpreter : public vtkObjectBase
{

	IPOINTER_AS_PART(Shell);
	IPOINTER_AS_USER(ErrorStatus);

public:

	vtkTypeMacro(iCommandInterpreter,vtkObjectBase);

	void Start();
	void Stop();

	void Append(const iString &text, char exec_char = ';');
	void Exec();

	virtual void DislayLineOfText(const iString &text, int type) const = 0;

	inline bool IsExecuted() const { return mExecuted; }
	inline int GetReturnState() const { return mReturnState; }
	inline const iString& GetExecutedScript() const { return mExecutedScript; }
	inline const iString& GetLastExecutedScriptPiece() const { return mLastExecutedScriptPiece; }

	virtual iControlScript* Script() const; // just in case... (to allow script substitutions)

protected:

	iCommandInterpreter(iShell *s);
	virtual ~iCommandInterpreter();

	virtual bool IsHelpRequest(const iString &line) const;
	virtual void RunScript(const iString &text, bool reset = false);

	virtual void Initialize() = 0;
	virtual void AnalyseSpecialCommands(const iString &line) = 0;
	virtual void Finalize() = 0;

private:

	//
	//  Private, to make sure they are not changed accidentally
	//
	bool mExecuted;
	int mReturnState;
	iString mBufferedScript, mExecutedScript, mLastExecutedScriptPiece;
};

#endif  // ICOMMANDINTERPRETER_H
