/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggpageparticles.h"


#include "icontrolmodule.h"
#include "idata.h"
#include "idatasubject.h"
#include "ierror.h"
#include "iimagefactory.h"
#include "iparticlegroup.h"
#include "iparticlesviewsubject.h"
#include "ipointglyph.h"
#include "ishell.h"
#include "iviewmodule.h"
#include "iviewobject.h"
#include "iviewobjectfamily.h"

#include "iggdatatypeprovider.h"
#include "iggextensionwindow.h"
#include "iggframecurrentinstance.h"
#include "iggframedatavariablelist.h"
#include "iggframefunctionmapping.h"
#include "iggframematerialproperties.h"
#include "iggframepaletteselection.h"
#include "iggframerangemapping.h"
#include "iggframereplicate.h"
#include "iggmainwindow.h"
#include "iggwidgetarea.h"
#include "iggwidgetkeybutton.h"
#include "iggwidgetkeycolorselection.h"
#include "iggwidgetkeylineedit.h"
#include "iggwidgetkeyselectionbox.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetotherbutton.h"

#include "ibgwidgetbuttonsubject.h"

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"
#include "iggwidgetkeyslidertemplate.h"


using namespace iParameter;
using namespace iParameter;


namespace iggPageParticles_Private
{
	//
	//  Helper class
	//
	class RangeMapping : public iggFrameRangeMapping
	{
		
	public:
		
		RangeMapping(iggFrame *dependent, iggFrame *parent) : iggFrameRangeMapping(iParticlesViewSubject::KeySplitRanges(),iParticlesViewSubject::KeySplitRangesTiled(),parent)
		{
			mDependent = dependent;
		}

		virtual void OnChange()
		{
			this->GetShell()->GetControlModule()->GetViewModule()->GetParticlesViewSubject()->ClearCache();
		}

		virtual bool IsActive()
		{
			int att;
			return (this->GetShell()->GetControlModule()->QueryValue(iParticlesViewSubject::KeyAttributeToSplit(),att) && att>=0);
		}

		virtual int GetCurrentRange()
		{
			int cur;
			if(this->GetShell()->GetControlModule()->QueryValue(iParticlesViewSubject::KeyCurrentGroup(),cur))
			{
				return cur;
			}
			else
			{
				IERROR_LOW("Failed querying iParticlesViewSubject::KeyCurrentGroup() key.");
				return 0;
			}
		}

		virtual void SetCurrentRange(int c)
		{
			iString ws;
			this->GetShell()->GetControlModule()->PackCommand(ws,iParticlesViewSubject::KeyCurrentGroup(),c);
			this->GetShell()->GetControlModule()->Execute(ws,false,this->GetExecuteFlags());
		}

		virtual void OnAddRange()
		{
		    if(this->GetShell()->GetControlModule()->CreateObject(iParticleGroup::Type(),false))
			{
				if(mDependent != 0) mDependent->UpdateWidget();
			}
		}

		virtual void OnRemoveRange()
		{
			if(this->GetShell()->GetControlModule()->DeleteObject(iParticleGroup::Type(),false))
			{
				if(mDependent != 0) mDependent->UpdateWidget();
			}
		}

		virtual void OnReset()
		{
			//
			//  Reset by setting the attribute to 0 and setting it back to what it was
			//
			iString ws;
			int att = 0;
			if(this->GetShell()->GetControlModule()->QueryValue(iParticlesViewSubject::KeyAttributeToSplit(),att))
			{
				this->GetShell()->GetControlModule()->PackCommand(ws,iParticlesViewSubject::KeyAttributeToSplit(),-1);
				this->GetShell()->GetControlModule()->Execute(ws,false,this->GetExecuteFlags());
				ws.Clear();
				this->GetShell()->GetControlModule()->PackCommand(ws,iParticlesViewSubject::KeyAttributeToSplit(),att);
				this->GetShell()->GetControlModule()->Execute(ws,false,this->GetExecuteFlags());
				if(mDependent != 0) mDependent->UpdateWidget();
			}
		}

	protected:

		iggFrame *mDependent;
	};


	class AdjustSizeSliderButton : public iggWidgetSimpleButton
	{

	public:

		AdjustSizeSliderButton(iggWidgetKeyFloatSlider *s, bool shrink, iggFrame *parent) : iggWidgetSimpleButton("",parent,true)
		{
			mSlider = s;
			mShrink = shrink;

			if(shrink) mSubject->SetIcon(*iImageFactory::FindIcon("moveright.png")); else mSubject->SetIcon(*iImageFactory::FindIcon("moveleft.png"));

			this->SetBaloonHelp("Adjust the lower limit of the size slider");
		}

	protected:

		virtual void Execute()
		{
			mSlider->AdjustLowerLimit(mShrink);
			mSlider->UpdateWidget();
		}

		bool mShrink;
		iggWidgetKeyFloatSlider *mSlider;
	};


	//
	//  Special provider
	//
	class ParticleTypeProvider : public iggDataTypeProvider
	{

	public:

		ParticleTypeProvider(iggPageParticles *page) : iggDataTypeProvider((page==0)?0:page->GetShell())
		{
			mPage = page; IERROR_ASSERT(page);
		}

		virtual int GetActiveDataTypeIndex() const
		{
			return mPage->GetParticlesObject()->GetActiveDataTypeIndex();
		}

		virtual void SetActiveDataTypeIndex(int v)
		{
			if(v != this->GetActiveDataTypeIndex())
			{
				mPage->SetCurrentParticles(v);
				mPage->GetMainWindow()->GetExtensionWindow()->UpdateOnDataType(this->GetActiveDataType());
				mPage->GetMainWindow()->UpdateAll();
			}
		}
		
		virtual const iDataInfo& GetDataInfo() const
		{
			return mPage->GetParticlesObject()->GetPrimaryDataInfo();
		}

		virtual const iDataType& GetActiveDataType() const
		{
			return mPage->GetParticlesObject()->GetDataType();
		}

		iggPageParticles *mPage;
	};
};


using namespace iggPageParticles_Private;


iggPageParticles::iggPageParticles(iggFrameBase *parent) : iggPageObject(parent,ViewSubject::Id::Particles)
{
	int i;

	const iImage *icon = iImageFactory::FindIcon("part.png");

	mCurrentParticles = this->GetParticlesObject()->GetActiveDataTypeIndex();

	//
	//  Replace provider
	//
	delete mProvider;
	mProvider = new ParticleTypeProvider(this); IERROR_ASSERT(mProvider);

	mIcons.Add(iImageFactory::FindIcon("part.png"));
	const iDataInfo &di(mProvider->GetDataInfo());
	const iImage *image;
	for(i=1; i<di.Count(); i++)
	{
		image = this->GetMainWindow()->GetExtensionWindow()->GetSpecialParticleIcon(di.Type(i));
		if(image == 0) mIcons.Add(icon); else mIcons.Add(image);
	}

	//
	//  Main page
	// ************************************************
	//
	iggFrame *page0 = new iggFrame(mBook,3);
	mBook->AddPage("Main",icon,page0);
	//
	//  Show
	//
	iggFrameCurrentInstance *ci = new iggFrameCurrentInstance(false,"Group","Group",iParticlesViewSubject::KeyCurrentGroup(),iParticlesViewSubject::KeyMaxGroup(),page0);
	ci->AddDependent(this);
	page0->AddLine(new iggWidgetShowButton(iParticlesViewSubject::Type(),page0),static_cast<iggWidget*>(0),ci);
	page0->AddSpace(2);
	//
	//  Method & color normals
	//
	iggFrame *tf = new iggFrame(page0,2);
	iggFrame *tf1 = new iggFrame(tf,1);
	iggWidgetKeyComboBox *tb = new iggWidgetKeyComboBox("Type",0,iParticleGroup::KeyType(),tf1);
	tf1->AddLine(tb);
	tf1->AddSpace(10);
	for(i=0; i<PointGlyphType::SIZE; i++)
	{
		tb->InsertItem(iPointGlyph::GetName(i));
	}
	tf->AddLine(tf1,new iggWidgetKeyColorSelection(iParticleGroup::KeyColor(),tf,false));

	page0->AddLine(tf);
	page0->AddSpace(10);
	//
	//  Opacity
	//
	iggWidgetKeyFloatSlider *os = new iggWidgetKeyFloatSlider(1.0e-4,1.0,40,1,5,"Opacity",iParticleGroup::KeyOpacity(),RenderMode::UseGlobal,page0);
	os->SetStretch(2,10);
	page0->AddLine(os,2);
	iggWidgetKeyFloatSlider *ss = new iggWidgetKeyFloatSlider(1.0e-2,1.0e2,40,1,5,"Size",iParticleGroup::KeyFixedSize(),RenderMode::UseGlobal,page0);
	ss->SetStretch(2,10);
	page0->AddLine(ss,2);
	iggFrame *tmp = new iggFrame(page0,4);
	tmp->AddLine(new AdjustSizeSliderButton(ss,false,tmp),new AdjustSizeSliderButton(ss,true,tmp),new iggWidgetTextArea("Expand/shrink the lower limit",tmp));
	tmp->SetColStretch(3,10);
	page0->AddLine(tmp);
	page0->AddLine(new iggWidgetKeyCheckBox("Scale particles automatically",iParticleGroup::KeyAutoScaled(),page0));
	page0->AddSpace(10);

	page0->SetColStretch(1,10); 

	//
	//  Paint page
	// ************************************************
	//
	iggFrame *page1 = new iggFrame(mBook,1);
	mBook->AddPage("Paint",icon,page1);
	//
	//  Book
	//
	iggFrameBook *pb = new iggFrameBook(page1);
	page1->AddLine(pb);
	//
	//  Palette page
	//
	iggFrame *pbpage0 = new iggFrame(pb,3);
	pb->AddPage("Palette",icon,pbpage0);

	iggFrame *pf = new iggFrame(pbpage0,2);
	iggFrameDataVariableList *pl = new iggFrameDataVariableList(mProvider,"Paint with...",iParticleGroup::KeyAttributeToColor(),0,pf);
	pl->InsertItem("None");
	pl->Complete();
	tmp = new iggFrame(pf);
	tmp->AddSpace(10);
	iggWidgetKeyStretchComboBox *ls = new iggWidgetKeyStretchComboBox(iParticleGroup::KeyStretchToColor(),tmp);
	tmp->AddLine(ls);
	tmp->AddSpace(10);
	pf->AddLine(pl,tmp);
	pbpage0->AddLine(pf);

	pbpage0->AddSpace(5);

	iggWidgetKeyVariableLimitsSlider *al = new iggWidgetKeyVariableLimitsSlider(mProvider,5,"Min",iParticleGroup::KeyLowerLimitToColor(),&iParticleGroup::KeyAttributeToColor(),&iParticleGroup::KeyStretchToColor(),RenderMode::UseGlobal,pbpage0,0,&iParticleGroup::KeyAttributeToColor());
	iggWidgetKeyVariableLimitsSlider *au = new iggWidgetKeyVariableLimitsSlider(mProvider,5,"Max",iParticleGroup::KeyUpperLimitToColor(),&iParticleGroup::KeyAttributeToColor(),&iParticleGroup::KeyStretchToColor(),RenderMode::UseGlobal,pbpage0,0,&iParticleGroup::KeyAttributeToColor());
	pl->AddDependent(al);
	pl->AddDependent(au);
	ls->AddDependent(al);
	ls->AddDependent(au);
	al->AddBuddy(au);
	pbpage0->AddLine(al,2);
	pbpage0->AddLine(au,2);

	pbpage0->AddSpace(10);

	pbpage0->AddLine(new iggFramePaletteSelection(true,iParticleGroup::KeyPalette(),pbpage0),2);
	pbpage0->AddSpace(20);

	pbpage0->SetColStretch(1,10);
	pbpage0->SetColStretch(2,3);

	//
	//  Material page
	//
	iggFrame *pbpage1 = new iggFrame(pb,2);
	pb->AddPage("Material",icon,pbpage1);

	pbpage1->AddLine(new iggFrameMaterialProperties(true,false,iParticleGroup::Type(),pbpage1));
	pbpage1->AddSpace(10);

	pbpage1->SetColStretch(0,10);
	pbpage1->SetColStretch(1,3);

	//
	//  Size page
	// ************************************************
	//
	iggFrame *page2 = new iggFrame(mBook,1);
	mBook->AddPage("Size",icon,page2);
	//
	//  Book
	//
	iggFrameBook *sb = new iggFrameBook(page2);
	page2->AddLine(sb);
	//
	//  Settings page
	//
	iggFrame *sbpage0 = new iggFrame(sb,3);
	sb->AddPage("Settings",icon,sbpage0);

	iggFrame *sf = new iggFrame(sbpage0,2);
	iggFrameDataVariableList *sl = new iggFrameDataVariableList(mProvider,"Size with...",iParticleGroup::KeyAttributeToSize(),0,sf);
	sl->InsertItem("None");
	sl->Complete();
	tmp = new iggFrame(sf);
	tmp->AddSpace(10);
	iggWidgetKeyStretchComboBox *lz = new iggWidgetKeyStretchComboBox(iParticleGroup::KeyStretchToSize(),tmp);
	tmp->AddLine(lz);
	tmp->AddSpace(10);
	sf->AddLine(sl,tmp);
	sf->AddLine(new iggWidgetKeyCheckBox("Use as size; scale by",iParticleGroup::KeyAttributeSizeDirect(),sf),new iggWidgetKeyFloatLineEdit("",iParticleGroup::KeyAttributeSizeExtraFactor(),RenderMode::UseGlobal,sf));
	
	sbpage0->AddLine(sf);

	sbpage0->AddSpace(5);

	iggWidgetKeyVariableLimitsSlider *bl = new iggWidgetKeyVariableLimitsSlider(mProvider,5,"Min",iParticleGroup::KeyLowerLimitToSize(),&iParticleGroup::KeyAttributeToSize(),&iParticleGroup::KeyStretchToSize(),RenderMode::UseGlobal,sbpage0,0,&iParticleGroup::KeyAttributeToSize());
	iggWidgetKeyVariableLimitsSlider *bu = new iggWidgetKeyVariableLimitsSlider(mProvider,5,"Max",iParticleGroup::KeyUpperLimitToSize(),&iParticleGroup::KeyAttributeToSize(),&iParticleGroup::KeyStretchToSize(),RenderMode::UseGlobal,sbpage0,0,&iParticleGroup::KeyAttributeToSize());
	sl->AddDependent(bl);
	sl->AddDependent(bu);
	lz->AddDependent(bl);
	lz->AddDependent(bu);
	bl->AddBuddy(bu);
	//
	//  Add paint limits as well
	//
	bl->AddBuddy(au);
	bu->AddBuddy(al);

	sbpage0->AddLine(bl,2);
	sbpage0->AddLine(bu,2);

	sbpage0->AddSpace(10);

	sbpage0->SetColStretch(1,10);
	sbpage0->SetColStretch(2,3);

	//
	//  Function page
	//
	iggFrame *sbpage1 = new iggFrame(sb,1);
	sb->AddPage("Function",icon,sbpage1);
	//
	//  FunctionMapping widget
	//
	sbpage1->AddLine(new iggFrameFunctionMapping(iParticleGroup::KeySizeFunction(),sbpage1));

	//
	//  Replicate page
	// ************************************************
	//
	iggFrame *page3 = new iggFrame(mBook,2);
	mBook->AddPage("Replicate",icon,page3);
	//
	//  Replicate
	//
	page3->AddLine(new iggFrameReplicate(iParticlesViewSubject::Type(),page3));
	page3->AddSpace(10);
	page3->SetColStretch(1,3);

	//
	//  Advanced page
	// ************************************************
	//
	iggFrame *page4 = new iggFrame(mBook,1);
	mBook->AddPage("Advanced",icon,page4);
	//
	//  Book
	//
	iggFrameBook *ab = new iggFrameBook(page4);
	page4->AddLine(ab);

	//
	//  Split page
	//
	iggFrame *abpage0 = new iggFrame(ab,1);
	ab->AddPage("Split into groups",icon,abpage0);

	//
	//  Book
	//
	iggFrameBook *db = new iggFrameBook(abpage0);
	abpage0->AddLine(db);
	//
	//  Main page
	//
	iggFrame *dbpage0 = new iggFrame(db,2);
	db->AddPage("Main",icon,dbpage0);

	iggFrameDataVariableList *av = new iggFrameDataVariableList(mProvider,"Split by...",iParticlesViewSubject::KeyAttributeToSplit(),0,dbpage0);
	av->InsertItem("Do not split");
	av->Complete(); // splitter's attributes start with -1
	dbpage0->AddLine(av);

	iggWidgetKeyStretchComboBox *as = new iggWidgetKeyStretchComboBox(iParticlesViewSubject::KeySplitRangesStretch(),dbpage0);
	dbpage0->AddLine(as);
	dbpage0->AddSpace(10);
	dbpage0->SetColStretch(1,3);
	//
	//  FunctionMapping widget
	//
	iggFrame *dbpage1 = new iggFrame(db,1);
	db->AddPage("Ranges",icon,dbpage1);

	RangeMapping *rm = new RangeMapping(this,dbpage1);
	av->AddDependent(rm);
	as->AddDependent(rm);
	
	dbpage1->AddLine(rm);

	//
	//  Connect page
	//
	iggFrame *abpage1 = new iggFrame(ab,3);
	ab->AddPage("Connect with lines",icon,abpage1);

	iggFrameDataVariableList *cv = new iggFrameDataVariableList(mProvider,"Connect by...",iParticleGroup::KeyAttributeToConnect(),0,abpage1);
	cv->InsertItem("Do not connect");
	cv->Complete(); // connector's attributes start with -1
	iggFrameDataVariableList *sv = new iggFrameDataVariableList(mProvider,"Separate by...",iParticleGroup::KeyAttributeToSeparate(),0,abpage1);
	sv->InsertItem("None");
	sv->Complete(); // connector's attributes start with -1
	abpage1->AddLine(cv,sv);

	abpage1->AddSpace(10);
	abpage1->SetColStretch(2,10);
}


void iggPageParticles::SetCurrentParticles(int n)
{
	if(n>=0 && n<this->GetParticlesObject()->GetNumberOfTypes())
	{
		mCurrentParticles = n;
		iString ws;
		this->GetShell()->GetControlModule()->PackCommand(ws,iViewModule::KeyParticlesCurrent(),n);
		this->GetShell()->GetControlModule()->Execute(ws,false);
#ifdef I_CHECK
		if(mIcons.Size() != this->GetParticlesObject()->GetNumberOfTypes())
		{
			IERROR_LOW("Bug in iggPageParticles: incompating mIcons array.");
		}
#endif
		if(n>=0 && n<mIcons.Size())
		{
			this->GetMainWindow()->UpdateParticleWidgets(mIcons[n]);
		}
		else
		{
			this->GetMainWindow()->UpdateParticleWidgets(mIcons[0]);
		}
	}
}


void iggPageParticles::AddIcon(const iImage *image)
{
	mIcons.Add(image);
}


void iggPageParticles::UpdateWidgetBody()
{
	if(mCurrentParticles != this->GetParticlesObject()->GetActiveDataTypeIndex())
	{
		this->SetCurrentParticles(this->GetParticlesObject()->GetActiveDataTypeIndex());
	}
//	this->GetMainWindow()->UpdateParticleWidgets(mIcons[mCurrentParticles]);
	this->iggPage::UpdateWidgetBody();
}


iViewObject* iggPageParticles::GetParticlesObject() const
{
	return this->GetShell()->GetControlModule()->GetViewModule()->GetParticlesObject();
}

#endif
