/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggreloading.h"


#include "icontrolmodule.h"
#include "idata.h"
#include "idatareader.h"
#include "ishell.h"
#include "iviewmodule.h"

#include "iggdatatypeprovider.h"
#include "iggmainwindow.h"


template<class Widget>
iggReloading<Widget>::iggReloading(const iDataInfo &info, const iggDataTypeProvider *provider, const iString &title, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : Widget(title,key,parent,index,indkey), mInfo(info), mProvider(provider), mReloadOnInt(true) {}

template<class Widget>
iggReloading<Widget>::iggReloading(const iDataInfo &info, const iggDataTypeProvider *provider, const iString &title, int offset, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : Widget(title,offset,key,parent,index,indkey), mInfo(info), mProvider(provider), mReloadOnInt(true) {}

template<class Widget>
iggReloading<Widget>::iggReloading(const iDataInfo &info, const iggDataTypeProvider *provider, int cols, const iString &title, int offset, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : Widget(cols,title,offset,key,parent,index,indkey), mInfo(info), mProvider(provider), mReloadOnInt(true) {}

template<class Widget>
iggReloading<Widget>::iggReloading(const iDataInfo &info, const iggDataTypeProvider *provider, int min, int max, int numdig, const iString &title, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey) : Widget(min,max,numdig,title,key,rm,parent,index,indkey), mInfo(info), mProvider(provider), mReloadOnInt(false) {}

template<class Widget>
iggReloading<Widget>::iggReloading(const iDataInfo &info, const iggDataTypeProvider *provider, iggFrameBase *parent, int cols) : Widget(parent,cols), mInfo(info), mProvider(provider), mReloadOnInt(true) {}


template<class Widget>
void iggReloading<Widget>::UpdateWidgetBody()
{
	if(mProvider != 0)
	{
		if(mInfo.Includes(mProvider->GetActiveDataType()))
		{
			this->Enable(true);
			Widget::UpdateWidgetBody();
		}
		else this->Enable(false);
	}
	else Widget::UpdateWidgetBody();
}


template<class Widget>
void iggReloading<Widget>::OnVoid1Body()
{
	Widget::OnVoid1Body();
	this->GetMainWindow()->RequestReloadData(mInfo);
}


template<class Widget>
void iggReloading<Widget>::OnInt1Body(int i)
{
	Widget::OnInt1Body(i);
	if(mReloadOnInt) this->GetMainWindow()->RequestReloadData(mInfo);
}


