<?
# Welcome to the IRM Configuration File.

# Configuration options follow this syntax:
# 	$variable = "<value>";
# It is important that you put he double-quotes around the value.
# If you should need to insert a double-quote as the value its self,
#  escape it out by using a backslash (\").  For example:
#	$variable = "The dog said, \"I like beans.\"  Then he ate some.";
# Comments are marked with a hash, #, character as the first symbol.  
#
# Enjoy!
#
# $Id: config.inc.php3,v 1.17.2.2 2000/05/16 05:35:50 atrus Exp $
#
################################################################################
#                                  CHANGELOG                                   #
################################################################################
#  8/06/99 - Keith Schoenefeld: Added CHANGELOG to config.inc file :)          #
#  8/06/99 - Keith Schoenefeld:	Added cfg_notifynewtrackingbyemail variable.   #
#  8/06/99 - Keith Schoenefeld: Changed cfg_notifybyemail to                   #
#				cfg_notifyassignedbymeail to better            #
#				distinguish between the email notifications.   #
#  8/06/99 - Keith Schoenefeld: Added the cfg_newtrackingemail option          #
#  9/11/99 - Keith Schoenefeld:	Added cfg_groups                               #
#  9/11/99 - Keith Schoenefeld:	Added cfg_trackingbyname                       #
#  1/1/00 - Yann Ramin: Added cfg_snmp_* and section TOC		       #
#  2/26/00 - Yann Ramin: Removed $cfg_dbdb for multi database support.         #
#  3/16/00 - Yann Ramin: Configureable expire fields			       #
################################################################################

# Sections:
# 1 - Database Configuration
# 2 - Functional Options
# 3 - Installation and Graphic Options
# 4 - SNMP Options


# Section 1: Database Configuration
# ---------------------------------
# Currently, IRM only supports MySQL. If there is interest, a pgSQL or MSSQL
# version can be run off.

# cfg_dbname: The database server and port.
# Syntax: $cfg_dbname = "<server>:<port>";
# Default: $cfg_dbname = "localhost:3306";

$cfg_dbname = "localhost:3306"; 

# cfg_dbuser: The database user
# Syntax: $cfg_dbuser = "<db-user>";
# Default: $cfg_dbuser = "root";

$cfg_dbuser = "root"; 

# cfg_dbpasswd: The dbuser's password.
# Syntax: $cfg_dbpasswd = "<password>";
# Default: $cfg_dbpasswd = "";

$cfg_dbpasswd = ""; 

# cfg_dbdb: REMOVED!!!
# For now, the default database used is simply named 'irm'.  If you wish to change this or add more,
# open up /index.php3 and add another <option value=dbname>Friendly Name</option> line.

# cfg_dbtype: Database type
# Syntax: $cfg_dbtype = "<database type>";
# Default: $cfg_dbtype = "mysql";
# At this time, only MySQL is supported.

$cfg_dbtype = "mysql";

# Section 2: Functional Options
# -----------------------------

# cfg_notifyassignedbyemail: Notify a person by e-mail when someone assigned 
# a job to them.
# Syntax: $cfg_notifyassignedbyemail = <1|0>; (1, yes, 0, no).
# Default: $cfg_notifyasssignedbyemail = 1;

$cfg_notifyassignedbyemail = 1;

# cfg_notifynewtrackingbyemail:  Notify a person by email when new tracking is
# added.
# Syntax: $cfg_notifynewtrackingbyemail = <1|0>; (1, yes, 0, no).
# Default: $cfg_notifynewtrackingbyemail = 0;

$cfg_notifynewtrackingbyemail = 0;

# cfg_newtrackingemail: The email of the person to notify when new tracking is 
# added. (requires $cfg_notifynewtrackingbyemail = 1)
# Syntax: $cfg_newtrackingemail = "email@address.com";
# Default: $cfg_newtrackingemail = "user@host.com";

$cfg_newtrackingemail = "user@host.com";

# cfg_groups: This allows you to set up groups of computers.  Specifically, it
# allows people to request work to be done on a lab of computers.
# Syntax: $cfg_groups = <1|0>; (1, yes, 0, no)
# Default: $cfg_groups = 0;

$cfg_groups = 0;

# $cfg_usenamesearch: Adds the ability to search by name in request help
# Syntax: $cfg_usenamesearch = <1|0>;
# Default: $cfg_usenamesearch = 1; 

$cfg_usenamesearch = 1; 

# $cfg_userupdates: Allows the user to receive updates on tracking entered
# via email.
# Syntax: $cfg_userupdates = <1|0>;
# Default: $cfg_userupdates = 1; 

$cfg_userupdates = 1;

# $cfg_sendexpire: Send expires and pragma nocache headers
# Syntax: $cfg_sendexpire = <1|0>;
# Default: $cfg_sendexpire = 0;

$cfg_sendexpire = 0;

# $cfg_showjobsonlogin: Show the assigned jobs to users on login.  By default,
# only the number of assigned jobs are displayed
# Syntax: $cfg_showjobsonlogin = <1|0>;
# Default: $cfg_showjobsonlogin = 1;

$cfg_showjobsonlogin = 1;

# $cfg_minloglevel: Minimum level which a entry needs to be at to be
# logged.  Chart:
# 1 - Critical (login failures)
# 2 - Severe
# 3 - Important
# 4 - Notice (updates, adds, deletes, tracking)
# 5 - Junk (i.e., setup dropdown fields)
# Default: $cfg_minloglevel = 5;

$cfg_minloglevel = 5;	 


# Section 3: Installation and Graphic Options
# -------------------------------------------

# PREFIX: The installed location of IRM, from the web-browsers point of view.
# Syntax: $PREFIX = "<path, i.e. /helpdesk/irm, /irm, /~joeuser/irm>";
# Default: $PREFIX = "/irm-<version>";

$PREFIX = "/irm-1.0.3"; 

# UPREFIX: The installed location of IRM including access protocol and server,
# 		from the web-browsers point of view.
# Syntax: $UPREFIX = "http<s>://your.webserver.com/<path, i.e. /helpdesk/irm,
#		/irm, /~joeuser/irm>";
# Default: $UPREFIX = "http://your.server.com/irm-<version>";

$UPREFIX = "http://your.server.com/irm-1.0.3";

# LOGO: The logo that appears over every page.
# Syntax: $LOGO = "<image file, i.e. irm_alt.jpg, http://pics.domain.com/irm.gif>";
# Default: $LOGO = "irm-jr1.jpg";
# Notes: The other entries show what other graphics were shipped with IRM:

$LOGO = "irm-jr1.jpg";
/* $LOGO = "irm.gif"; */
/* irm-jr1.jpg and irm-jr2.jpg are graciously donated by John Rappold and company */
/* They're cool, we like them, the new default */


# Section 4: SNMP Options
# -----------------------

# NOTE:  SNMP support in IRM is ALPHA quality.  Please don't rely on it working,
# updating your database, etc.  Supplied perl scripts fall under this catagory as well.
# Contact Yann Ramin <atrus@atrustrivalie.eu.org> if you are thinking of enabling/using
# SNMP in a large scale production enviroment.
# PLEASE READ docs/SNMP IF YOU PLAN ON ENABLING SNMP/MONITORING FEATURES AT ALL

# cfg_snmp: The master switch.  Enables or disables all SNMP PHP code.
# Syntax: $cfg_snmp = 1|0;
# Default: $cfg_snmp = 0;

$cfg_snmp = 0;

# cfg_snmp_rcommunity: The read or public community
# Syntax: $cfg_snmp_rcommunity = "<community>";
# Default: $cfg_snmp_rcommunity = "public";

$cfg_snmp_rcommunity = "public";

# cfg_snmp_ping: Ping the computer when it is loaded in the computer editer.
# This can cause big delays if the host is down - use with caution.  This does
# not effect the 'Running Computers' or the Runtime Information (SNMP) features.
# Syntax: $cfg_snmp_ping = 1|0;
# Default: $cfg_snmp_ping = 0;

$cfg_snmp_ping = 0;



# End of configuration file.  Have a nice millenium.

?>
