/*      
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* utilites for iroffer */

#ifndef _OS_SunOS
void msleep (int msec) {
/*   sunos */
/*   extern unsigned usleep(unsigned); */
/*   extern unsigned usleep(); */
/*   usleep((unsigned int)(msec*1000)); */
   usleep((long)(msec*1000));
   }
#endif _OS_SunOS

int strcmppart (char *str, char *match) {
   int temp, i;
   
   if (!str || !match) return 0;
   
   if ( strlen(str) < strlen(match) ) return 0;

   temp=0;
   
   for (i=0; i<sstrlen(match); i++)
      if ( str[i] != match[i] )
         temp++;
   
   if (temp == 0)
      return 1;
   else
      return 0;
   
   }

int strcmpany (char *str, char *match) {
   int temp, i, j, found;
   
   if (!str || !match) return 0;
   
   if ( strlen(str) < strlen(match) ) return 0;
   
   found=0;
   for (j=0; j<sstrlen(str)-sstrlen(match)+1; j++) {
      temp=0;
      for (i=0; i<sstrlen(match); i++)
         if ( str[i+j] != match[i] )
            temp++;
      if (temp == 0) found = 1;
      }
   
   return found;
   }

int strcmpend (char *str, char *match) {
   int temp, i,j;
   
   if (!str || !match) return 0;
   
   if ( strlen(str) < strlen(match) ) return 0;

   temp=0;
   
   for (i=strlen(str)-1, j=strlen(match)-1; i>=0 && j>=0; i--,j--)
      if ( str[i] != match[j] )
         temp++;
   
   if (temp == 0)
      return 1;
   else
      return 0;
   
   }

char* getpart(char *line, int howmany, const char *src) {
   char *part;
   int i,j,k;
   i=0; j=0;
   
   for (k=1; k<howmany; k++) {
      while (line[i] != ' ')
         if (line[i] == '\0') {
            return NULL;
            }
         else
            i++;
      i++;
      }

   part = mycalloc(maxtextlength,src);
   
   while (line[i] != ' ' && line[i] != '\0') {
      part[j] = line[i];
      i++; j++;
      }
   part[j]='\0';

   
   return part;
   }

char* caps(char *text) {
   int i;
   if (text)
      for (i=0; i<sstrlen(text); i++)
          if ( text[i] > 96 && text[i] < 123 )
             text[i] = text[i]-32;
   return text;
   }


char* sizestr(int spaces, char* str, unsigned long num) {
   
   if      (num >= 1024*1024*1000)
      /* >1000MB */
      snprintf(str,5,"%2.1fG",(((float)num)/(1024.0*1024.0*1024.0)));
   else if (num >= 1024*1024*10)
      /* >10MB */
      snprintf(str,5,spaces?"%3.0fM":"%.0fM",(((float)num)/(1024.0*1024.0)));
   else if (num >= 1024*1000)
      /* >1000k */
      snprintf(str,5,"%2.1fM",(((float)num)/(1024.0*1024.0)));
   else if (num >= 1024)
      /* >1k */
      snprintf(str,5,spaces?"%3.0fK":"%.0fK",(((float)num)/1024.0));
   else if (num >= 1)
      /* <1k */
      snprintf(str,5,spaces?" <1K":"<1K");
   else {
      outerror(2,"File size unknown");
      snprintf(str,5,"???K");
      }
   
   return str;
   }

int highestsock () {
   int i,highest;
   highest = 0;
   
   highest = ircserver;
   
   if (dccchat != 1000 && dccchat > highest)
      highest = dccchat;
   if (dccchatlisten != 1000 && dccchatlisten > highest)
      highest = dccchatlisten;
   
   for (i=0; i<MAXTRANS; i++)
      if (trans[i] != NULL) {
         if (trans[i]->listensocket > highest && trans[i]->listensocket != 1000)
            highest = trans[i]->listensocket;
         if (trans[i]->clientsocket > highest && trans[i]->clientsocket != 1000)
            highest = trans[i]->clientsocket;
         }
   highests = highest;
   if (debug) {
      ioutput1(1,OUT_S,"0;33","highest socket = ");
      ioutputi(OUT_S,highests);
      ioutput1(3,OUT_S,"0;33","");
      }
   return highest;
   }

void getos () {

   struct utsname u1;
   highmeminfo = 1;
   
   if ( uname(&u1) < 0)
      outerror(0,"Couldn't Get Your OS Type");
   
   printf("*** You Are Running %s %s on a %s",u1.sysname,u1.release,u1.machine);
/*        << "*** You Are Running " */
/*        << u1.sysname << " " */
/*//        << u.nodename << " " */
/*        << u1.release << " on a " */
/*//        << u.version << " " */
/*        << u1.machine; */
   
   osstring = mycalloc(maxtextlengthshort,"getos_osstring");
   
   snprintf(osstring,maxtextlengthshort-2,"%s %s",u1.sysname,u1.release);
   
   /* verify we are who we were configured for, and set config */
#if defined(_OS_Linux_x86)   || \
    defined(_OS_Linux_PPC)   || \
    defined(_OS_Linux_alpha) || \
    defined(_OS_Linux_sparc) || \
    defined(_OS_Linux_sparc64)
   if (strcmp(u1.sysname,"Linux"))
      outerror(0,"Configued for Linux but not running Linux?!?");
   printf(", Good\n");
   
#elif defined(_OS_FreeBSD)  || \
    defined(_OS_OpenBSD)     || \
    defined(_OS_BSDI)        || \
    defined(_OS_BSD_OS)
   if (strcmp(u1.sysname,"FreeBSD") && strcmp(u1.sysname,"OpenBSD") && strcmp(u1.sysname,"BSD/OS"))
      outerror(0,"Configued for *BSD but not running *BSD?!?");
   printf(", Good\n");

#elif defined(_OS_SunOS)
   if (strcmp(u1.sysname,"SunOS"))
      outerror(0,"Configued for Solaris but not running Solaris?!?");
   printf(", Good\n");

#endif
   
   highmeminfo = 0;
   }

int getend(int amt, int num) {
   
   if (num < 0)
      return num+amt;
   else
      return num;
   
   }

int getbeg(int amt, int num) {
   
   if (num > amt-1)
      return num-amt;
   else
      return num;
   
   }

int getsrv(int amt, int num) {
   
   if (num < 1)
      return num+amt;
   else
      return num;
   
   }


void floodchk() {
   int i,count,last;
   
   count = 0;
   last = ignore;
   
   for (i=0; i<10; i++) {
      count += inamnt[i];
      }

   if (count > 6 && RCV_FPROT)
      ignore = 1;
   else
      ignore = 0;
   
   if (last - ignore == -1) {
      if (!attop) gototop();
      outerror(2,"Flood Protection Activated");
      }
   if (last - ignore == 1) {
      if (!attop) gototop();
      outerror(2,"Flood Protection Deactivated");
      }
   
   }

void outerror3 (int type, char* err1, char* err2, char* err3) {
   if (!background && !attop) gototop();
   
   if ( type == 0 ) {
      
      ioutput4(0,OUT_S|OUT_L|OUT_D,"1;31","ERROR: ",err1,err2,err3);
      
      if (!background)
         printf("[r[%i;1H\n",termlines);
      else
         printf("*** ERROR: %s%s%s\n\n",err1,err2,err3);
         
      log1(0,"iroffer exited (Error)\n\n");
      if (pidfile) unlink(pidfile);

      exit(1);
      }
   else if (type == 1 ) {
      ioutput4(0,OUT_S|OUT_L|OUT_D,"1;31","WARNING: ",err1,err2,err3);
      if (background)
         printf("*** WARNING: %s%s%s\n",err1,err2,err3);
      }
   else if (type == 2 ) {
      ioutput4(0,OUT_S|OUT_L|OUT_D,"0;31","WARNING: ",err1,err2,err3);
      if (background)
         printf("*** WARNING: %s%s%s\n",err1,err2,err3);
      }
   }

char* getdatestr(char* str, time_t Tp) {
   struct tm *localt = NULL;

   if (Tp == 0) time(&Tp);
   localt = localtime(&Tp);
   strftime (str, 50, "%Y-%m-%d-%H:%M:%S", localt);
   
  /* mydelete(localt); */
   return str;
   }

void log6(int beg, char* a, char* b, char* c, char* d, char* e, char* f) {
   int filedescriptor;
   char *tempstr;
   
   /* beg = 0, normal */
   /* beg = 1, first part of multiple part line */
   /* beg = 2, middle part of multiple part line */
   /* beg = 3, end of multiple part line */
   
   if (logfile == NULL)
      return;
   
   filedescriptor=open(logfile, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR );
   if (filedescriptor < 0) {
      outerror(1,"Couldn't open/create Log File");
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   if (beg < 2) {
      tempstr = mycalloc(maxtextlength,"log6");
      write(filedescriptor,"** ",3);
      getdatestr(tempstr,0);
      write(filedescriptor,tempstr,strlen(tempstr));
      write(filedescriptor,": ",2);
      mydelete(tempstr);
      }

   if (a) write(filedescriptor,a,strlen(a));
   if (b) write(filedescriptor,b,strlen(b));
   if (c) write(filedescriptor,c,strlen(c));
   if (d) write(filedescriptor,d,strlen(d));
   if (e) write(filedescriptor,e,strlen(e));
   if (f) write(filedescriptor,f,strlen(f));
   
   if (beg == 0 || beg == 3)
      write(filedescriptor,"\n",1);
   
   close(filedescriptor);
   
   }


void logi(int num) {
   int filedescriptor;
   char *tempstr2;
   
   if (logfile == NULL)
      return;
   
   filedescriptor=open(logfile, O_WRONLY);
   if (filedescriptor < 0) {
      outerror(1,"Couldn't open/create Log File");
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   tempstr2 = mycalloc(maxtextlengthshort,"logi");
   snprintf(tempstr2,maxtextlengthshort-2,"%i",num);
   write(filedescriptor,tempstr2,strlen(tempstr2));
   mydelete(tempstr2);
   
   close(filedescriptor);
   
   }

void logstat() {
   int filedescriptor;
   char *tempstr, *tempstr2;
   
   if (logfile == NULL)
      return;
   
   tempstr = mycalloc(maxtextlength,"logstat");
   tempstr2 = mycalloc(maxtextlengthshort,"logstat");
   
   filedescriptor=open(logfile, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR );
   if (filedescriptor < 0) {
      outerror(1,"Couldn't open/create Log File");
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   write(filedescriptor,"** ",3);
   getdatestr(tempstr,0);
   write(filedescriptor,tempstr,strlen(tempstr));
   write(filedescriptor,": ",2);
   
   
   getstatusline(tempstr);
      
   write(filedescriptor,tempstr,strlen(tempstr));

   write(filedescriptor,"\n",1);
   
   close(filedescriptor);
   
   mydelete(tempstr);
   mydelete(tempstr2);
   
   }

unsigned long atoul (char *str) {
   unsigned long num,temp;
   int i,j;
   if (str == NULL) return 0;
   
   num = 0;
   
   for (i=strlen(str)-1; i>=0; i--) {
      temp = (str[i]-'0');
      for (j=strlen(str)-1; j>i; j--)
         temp *= 10;
      num += temp;
      }
   return num;
   }

void ioutput6(int beg, int dest, char *color,
             char *a, char *b, char *c, char *d, char *e, char *f) {
   
   /* beg = 0, normal */
   /* beg = 1, first part of multiple part line */
   /* beg = 2, middle part of multiple part line */
   /* beg = 3, end of multiple part line */
   
   /* screen */
   if (!background && (dest & OUT_S)) {
      
      if (!attop) gototop();
      
      if (beg == 0 || beg == 1) {
         if (USECOLOR && color)
            printf("[%sm",color);
         printf("*** ");
         }
      
      printf("%s%s%s%s%s%s",a?a:"",b?b:"",c?c:"",d?d:"",e?e:"",f?f:"");
      
      if (beg == 0 || beg == 3) {
         if (USECOLOR && color)
            printf("[0m\n");
         else
            printf("\n");
         }
      }
   
   /* log */
   if (dest & OUT_L)
      log6(beg,a,b,c,d,e,f);
   
   /* dcc chat */
   if (dccchat != 1000 && dccchatin && (dest & OUT_D)) {
      
      
      if (beg == 0 || beg == 1)
         write(dccchat,"--> ",4);
      if (a) write(dccchat,a,strlen(a));
      if (b) write(dccchat,b,strlen(b));
      if (c) write(dccchat,c,strlen(c));
      if (d) write(dccchat,d,strlen(d));
      if (e) write(dccchat,e,strlen(e));
      if (f) write(dccchat,f,strlen(f));
      
      if (beg == 0 || beg == 3) write(dccchat,"\n",1);
      
      if (!background && debug) {
         if (!attop) gototop();
         if (beg == 0 || beg == 1)
            printf("[0;36m<DCC<: ");
         printf("%s%s%s%s%s%s",a?a:"",b?b:"",c?c:"",d?d:"",e?e:"",f?f:"");
         if (beg == 0 || beg == 3)
            printf("[0m");
         }

      }
   
   }


void ioutputi(int dest, int num) {
   char *tempstr2 = mycalloc(maxtextlengthshort,"ioutputi");
   snprintf(tempstr2,maxtextlengthshort-2,"%i",num);
   
   /* screen */
   if (!background && (dest & OUT_S)) {
      if (!attop) gototop();
      printf("%i",num);
      }

   /* log */
   if (dest & OUT_L)
      log1(2,tempstr2);

   /* dcc chat */
   if (dccchat != 1000 && dccchatin && (dest & OUT_D))
      write(dccchat,tempstr2,strlen(tempstr2));

   mydelete(tempstr2);
   
   }

void privmsg5(char *nick, char *a, char *b, char *c, char *d, char *e) {
   char *tempstr;

   if (!nick || !a) return;
   
   tempstr = mycalloc(maxtextlength,"privmsg5");
   
   snprintf(tempstr,maxtextlength-1,"PRIVMSG %s :%s%s%s%s%s",
      nick, a, b, c, d, e);
   writeserver(tempstr);
   
   mydelete(tempstr);
   
   }

void notice5(char *nick, char *a, char *b, char *c, char *d, char *e) {
   char *tempstr;
   if (!nick || !a) return;
   
   tempstr = mycalloc(maxtextlength,"notice5");
   
   snprintf(tempstr,maxtextlength-1,"NOTICE %s :%s%s%s%s%s",
      nick, a, b, c, d, e);
   writeserver(tempstr);
   
   mydelete(tempstr);
   
   }

char* hostmasktoregex(char *str) {
   char *tempstr;
   int i,j;
   
   if (!str) return NULL;
   
   tempstr = mycalloc(maxtextlength,"hostmasktoregex");
   
   strcpy(tempstr,"^");
   
   for (i=0,j=1; i<sstrlen(str); i++,j++) {
      if ( (str[i] >= 'a' && str[i] <= 'z')
        || (str[i] >= 'A' && str[i] <= 'Z')
        || (str[i] >= '0' && str[i] <= '9') )
         tempstr[j] = str[i];
      else if (str[i] == '?')
         tempstr[j] = '.';
      else if (str[i] == '*') {
         tempstr[j] = '.'; j++;
         tempstr[j] = '*';
         }
      else if (str[i] == '#') {
         tempstr[j] = '['; j++;
         tempstr[j] = '0'; j++;
         tempstr[j] = '-'; j++;
         tempstr[j] = '9'; j++;
         tempstr[j] = ']'; j++;
         tempstr[j] = '+';
         }
      else {
         tempstr[j] = '\\'; j++;
         tempstr[j] = str[i];
         }
      }
   
   tempstr[j] = '$';
   tempstr[j+1] = '\0';
   
   strcpy(str,tempstr);
   mydelete(tempstr);
   
   return str;
   
   }

int verifyadmin(char *hmask) {
   int i,found = 0;
   
   for (i=0; i<MAXAHOST; i++)
      if (adminhost[i] != NULL && !regexec(adminhost[i],hmask,0,NULL,0))
         found=1;

   return found;
   }

int packnumtonum(char *a) {
   
   if (!a) return 0;
   
   if (a[0] == '#' && (strlen(a) <= 3)
             && a[1] > 47 && a[1] < 58
             && ( (strlen(a) == 2) || (a[2] > 47 && a[2] < 58) )) {
      
      a[0] = a[1];
      if (strlen(a) != 2) {
         a[1] = a[2];
         a[2] = '\0';
         }
      else
         a[1] = '\0';
      
      }
   
   return atoi(a);
   
   }


int sstrlen (char *p) {
   if (!p) return -1;
   return ((int)(strlen(p)));
   }

char dayofweektomask(char a) {
   switch (a) {
      case 'U':
         return 0x01;
      case 'M':
         return 0x02;
      case 'T':
         return 0x04;
      case 'W':
         return 0x08;
      case 'R':
         return 0x10;
      case 'F':
         return 0x20;
      case 'S':
         return 0x40;
      default:
         return 0x00;
      }
   return 0;
   }


void msglog_add(char* hostmask, char* line) {
   int filedescriptor, i, j;
   char *tempstr;
   
   if (messagefile == NULL)
      return;
   
   filedescriptor=open(messagefile, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR );
   if (filedescriptor < 0) {
      outerror(1,"Couldn't open/create Message File");
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   for (i=0, j=0; i<sstrlen(line) && j<3; i++)
      if (line[i] == ' ') j++;
   i++;
   
   for (j=i; j<sstrlen(line)+1; j++)
      line[j-i] = line[j];
   
   tempstr = mycalloc(maxtextlength,"msglog_add");
   snprintf(tempstr,maxtextlength-2,"%010lu %s %s\n",curtime,hostmask,line);
   write(filedescriptor,tempstr,strlen(tempstr));
   mydelete(tempstr);
   
   close(filedescriptor);
   
   }

char* msglog_howmany(char *str) {
   int fd,count=0;
   char *tempstr;
   
   fd=open(messagefile, O_RDONLY);
   if (fd < 0) {
      snprintf(str,maxtextlengthshort-2,"MSGLOG: messagefile couldn't be opened");
      return str;
      }
   
   tempstr = mycalloc(maxtextlength,"msglog_howmany_tempstr");
   while (( getfline(tempstr,fd,0)) != NULL) {
      count++;
      }
   mydelete(tempstr);
   close(fd);
   
   snprintf(str,maxtextlength-2,
   "*** You have %i message%s in the message log%s",count,count!=1?"s":"",count?", use MSGREAD to read them":"");
   
   return str;
   }

/* reverse a string */
char *strrev(char *str) {
   int i,len;
   char c;
   
   len = sstrlen(str);
   for (i=0; i<len/2; i++) {
      c = str[i];
      str[i] = str[len-i];
      str[len-i] = c;
      }
   
   return str;
   }

int isprintable(char a) {
   if ( a >= 0x20 && a <= 0x7E )
      return 1;
   else
      return 0; 
   }

char onlyprintable(char a) {
   if ( a >= 0x20 && a <= 0x7E )
      return a;
   else
      return '.'; 
   }

void* mycalloc(int a, const char *r) {
   void *t = NULL;
   int i,start=0;
   
   for (i=0; (i<100 && t == NULL); i++)
      t = calloc(a,1);
   
   if (t == NULL)
      outerror(0,"Couldn't Allocate Memory After 100 Attempts!!");
   
#if MEMINFOCHECK
   
   if (highmeminfo) start=500;
   
   for (i=start; (i<MAXMEMINFO && meminfo[i].ptr); i++) ;
   
   if (i == MAXMEMINFO) { i--; outerror(2,"Out of meminfo slots!"); }
   
   meminfo[i].ptr       = t;
   meminfo[i].src       = r;
   meminfo[i].alloctime = curtime;
   meminfo[i].size      = a;
   
#endif   
   
   return t;
   }

void mydeletepart(void *t) {
   static char errstr[100];
   unsigned char *ut = (unsigned char *)t;
   int i;
   
   if (t == NULL) return;
   
#if MEMINFOCHECK
   
   for (i=0; (i<MAXMEMINFO && (meminfo[i].ptr != t)); i++) ;
   
   if (i == MAXMEMINFO) {
      snprintf(errstr,99,"Pointer 0x%8.8lX not found in meminfo database while trying to free!!",(long)t);
      outerror(1,errstr);
      outerror(1,"Please report this error to PMG");
      for(i=0; i<(12*12); i+=12) {
         snprintf(errstr,99," : %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X = \"%c%c%c%c%c%c%c%c%c%c%c%c\"",
               ut[i+0], ut[i+1], ut[i+2], ut[i+3], ut[i+4], ut[i+5], ut[i+6], ut[i+7], ut[i+8], ut[i+9], ut[i+10], ut[i+11],
               onlyprintable(ut[i+0]), onlyprintable(ut[i+1]),
               onlyprintable(ut[i+2]), onlyprintable(ut[i+3]),
               onlyprintable(ut[i+4]), onlyprintable(ut[i+5]),
               onlyprintable(ut[i+6]), onlyprintable(ut[i+7]),
               onlyprintable(ut[i+8]), onlyprintable(ut[i+9]),
               onlyprintable(ut[i+10]), onlyprintable(ut[i+11]));
         outerror(1,errstr);
         }
      }
   else {
      free(t);
      
      meminfo[i].ptr       = NULL;
      meminfo[i].src       = NULL;
      meminfo[i].alloctime = 0;
      meminfo[i].size      = 0;
      
      }
      
#else
   free(t);
#endif   
   
   return;
   }







