/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtkhtml.dom;

import org.gnu.glib.GObject;

public class DomNode extends GObject {
    // This constructor should not be called, but it necessary for subclasses
    protected DomNode() {
    }

    public DomNode(int handl) {
	super(handl);
    }

    public DomDocumentType getDocumentType()
    {
	int handl = dom_Node_get_doctype(getHandle());
	return new DomDocumentType(handl);
    }

    public long getType() {
	return (dom_node_get_type());
    }

    public DomNode makeRef() {
	return (new DomNode(getHandle()));
    }

    //public Collection getChildNodes() {
    //	return (null);
    //}	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int dom_node_get_type();
	native static final protected int dom_Node_mkref(int node);
	native static final protected int dom_Node_get_childNodes(int node);
	native static final protected int dom_Node_removeChild(int node, int oldChild, int[] exception);
	native static final protected String dom_Node_get_nodeValue(int node, int[] exception);
	native static final protected int dom_Node_get_firstChild(int node);
	native static final protected String dom_Node_get_nodeName(int node);
	native static final protected int dom_Node_get_attributes(int node);
	native static final protected boolean dom_Node_hasChildNodes(int node);
	native static final protected int dom_Node_get_parentNode(int node);
	native static final protected int dom_Node_get_nextSibling(int node);
	native static final protected int dom_Node_get_nodeType(int node);
	native static final protected int dom_Node_cloneNode(int node, boolean deep);
	native static final protected int dom_Node_appendChild(int node, int newChild, int[] exception);
	native static final protected String dom_Node_get_localName(int node);
	native static final protected String dom_Node_get_namespaceURI(int node);
	native static final protected int dom_Node_get_previoussibling(int node);
	native static final protected int dom_Node_get_lastChild(int node);
	native static final protected void dom_Node_set_nodeValue(int node, String value, int[] exception);
	native static final protected int dom_Node_get_ownerDocument(int node);
	native static final protected boolean dom_Node_hasAttributes(int node);
	native static final protected int dom_Node_get_doctype(int node);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
