// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the mouse_event_observer class, which provides a pluggable default implementation of imouse_event_observer
		\author Tim Shead (tshead@k-3d.com)
*/

#include "mouse_event_observer.h"

namespace k3d
{

mouse_event_observer::mouse_event_observer(const std::string& Usage) :
	m_usage(Usage)
{
}

mouse_event_observer::~mouse_event_observer()
{
}

const std::string mouse_event_observer::Usage()
{
	return m_usage;
}

bool mouse_event_observer::OnMouseMove(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnLButtonDown(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnLButtonClick(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnLButtonUp(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnLButtonDoubleClick(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnLButtonDrag(const event_state& State, const vector2& Current, const vector2& Last, const vector2& Start, const drag_type_t DragType)
{
	return false;
}

bool mouse_event_observer::OnMButtonDown(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnMButtonClick(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnMButtonUp(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnMButtonDoubleClick(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnMButtonDrag(const event_state& State, const vector2& Current, const vector2& Last, const vector2& Start, const drag_type_t DragType)
{
	return false;
}

bool mouse_event_observer::OnRButtonDown(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnRButtonClick(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnRButtonUp(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnRButtonDoubleClick(const event_state& State, const vector2& Current)
{
	return false;
}

bool mouse_event_observer::OnRButtonDrag(const event_state& State, const vector2& Current, const vector2& Last, const vector2& Start, const drag_type_t DragType)
{
	return false;
}

} // namespace k3d


