#ifndef K3DUI_COMMAND_NODE_INSPECTOR_H
#define K3DUI_COMMAND_NODE_INSPECTOR_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the command_node_inspector class, which provides an interactive UI for working with the hierarchy of k3d::icommand_node objects
		\author Tim Shead (tshead@k-3d.com)
*/

#include "k3ddialog.h"

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// command_node_inspector

/// Provides an interactive UI for working with the hierarchyof k3d::icommand_node objects
class command_node_inspector :
	public k3dDialog
{
	typedef k3dDialog base;
	
public:
	command_node_inspector(k3d::icommand_node& Parent);

private:
	// A private destructor prohibits non-heap creation of objects of this class and also prevents inheritance. Objects of this class are destroyed by on_application_closed()
	~command_node_inspector();

	// Event-handling ...
	void OnEvent(sdpGtkEvent* Event);
	void on_tree_clicked(sdpGtkEvent* Event);

	/// Called by the signal system when the command tree is modified
	void on_command_tree_changed();
	/// Called by the signal system when the application is closed
	void on_application_closed();

	void reset_control();
	static gint raw_reset(gpointer Data);
	gint reset();

	/// Maintains a reference to the currently-selected node
	k3d::icommand_node* m_Selection;

	/// Maintains a connection to the command tree so we can disconnect it at shutdown
	SigC::Connection m_command_tree_connection;

	/// Keeps track of the idle-handler we use to handle display updates
	guint m_idle_handler;
};

} // namespace k3d

#endif // K3DUI_COMMAND_NODE_INSPECTOR_H
