#ifndef MODULE_BITMAP_BITMAP_FILTER_SIMPLE_H
#define MODULE_BITMAP_BITMAP_FILTER_SIMPLE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
          \author Anders Dahnielson (anders@dahnielson.com)
*/

#include <k3dsdk/bitmap_filter.h>
#include <k3dsdk/object.h>
#include <k3dsdk/persistence.h>

namespace libk3dbitmap
{

class bitmap_filter_simple :
	public k3d::bitmap_filter<k3d::persistent<k3d::object> >
{
	typedef k3d::bitmap_filter<k3d::persistent<k3d::object> > base;

public:
	bitmap_filter_simple(k3d::idocument& Document) :
		base(Document)
	{
		m_input.changed_signal().connect(SigC::slot(*this, &bitmap_filter_simple::on_reset_bitmap));
		m_output.need_data_signal().connect(SigC::slot(*this, &bitmap_filter_simple::on_create_bitmap));
	}

	void on_reset_bitmap()
	{
		m_output.reset();
	}

	k3d::bitmap* on_create_bitmap()
	{
		// If we don't have any input bitmap, we're done ...
		const k3d::bitmap* const input = m_input.property_value();
		if(!input)
			return 0;

		// Update values
		on_value_change();

		// Otherwise, we make a copy of the input bitmap and modify the copy ...
		k3d::bitmap* const output = new k3d::bitmap(*input);
		for (k3d::bitmap::iterator O = output->begin(); O != output->end(); ++O)
		{
			k3d::pixel I = *O;
			on_filter(I, *O);
		}

		return output;
	}

	virtual void on_value_change() = 0;
	virtual void on_filter(const k3d::pixel& I, k3d::pixel& O) = 0;
};

} // namespace libk3dbitmap

#endif // !MODULE_BITMAP_BITMAP_FILTER_SIMPLE_H

