########################################################
# K3D_WITH_NGUI

AC_DEFUN([K3D_WITH_NGUI], [
AC_SUBST(K3D_NGUI_SUBDIR)
AC_SUBST(K3D_BUG_BUDDY_SUBDIR)
AC_SUBST(K3D_GTKMM_CFLAGS)
AC_SUBST(K3D_GTKMM_LIBS)
AC_SUBST(K3D_GTKGLEXT_CFLAGS)
AC_SUBST(K3D_GTKGLEXT_LIBS)
AC_ARG_WITH(ngui, [  --with-ngui             build NGUI user-interface plug-in  [[yes]]],[],[withval=yes])
if test x$withval != xno; then
	AC_MSG_CHECKING([for gtkmm to build NGUI])
	if [pkg-config --exists gtkmm-2.4]; then
		K3D_NGUI_SUBDIR="ngui"
		K3D_BUG_BUDDY_SUBDIR="bug-buddy"
		K3D_GTKMM_VERSION=`pkg-config --modversion gtkmm-2.4`
		K3D_GTKMM_CFLAGS="`pkg-config --cflags gtkmm-2.4` -DK3D_HAVE_GTKMM_2_4"
		K3D_GTKMM_LIBS=`pkg-config --libs gtkmm-2.4`
		AC_MSG_RESULT([found version $K3D_GTKMM_VERSION])
	else
		AC_MSG_ERROR([couldn't find gtkmm libraries ... if you don't require the NGUI user interface, re-run configure using the --without-ngui option])
	fi

	AC_MSG_CHECKING([for gtkglext (required by NGUI)])
	if [pkg-config --exists gtkglext-1.0]; then
		K3D_GTKGLEXT_VERSION=`pkg-config --modversion gtkglext-1.0`
		K3D_GTKGLEXT_CFLAGS=`pkg-config --cflags gtkglext-1.0`
		K3D_GTKGLEXT_LIBS=`pkg-config --libs gtkglext-1.0`
		AC_MSG_RESULT([found version $K3D_GTKGLEXT_VERSION])
	else
		AC_MSG_ERROR([gtkglext required but not found])
	fi
fi
])

