/***************************************************************************
                          kplace.h  -  description
                             -------------------
    begin                : Tue Aug 8 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLACE_H
#define KPLACE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <qobject.h>
#include <qlist.h>
#include <qptrdict.h>

class QBoxLayout;
class QString;
class QWidget;
class QRadioButton;
class QCheckBox;
class QPushButton;
class QLineEdit;
class QMultiLineEdit;
class QSpinBox;
class QListBox;
class QDialog;
class QListView;
class QListViewItem;
class QCheckViewItem;
class QWidgetStack;
class KProcess;
class KRule;
class Kaptain;

#define BORDER 10
#define SPACING 5
/**Place, which is the visualisation of a nonterminal.
  *@author Terk Zsolt
  */

class KPlace : public QObject
{
  Q_OBJECT

  /* children of this */
  QList<KPlace> subPlaces;

  /* create special widget */
  QWidget * makeSpecial (KRule *, QWidget *, QBoxLayout *);

  QWidget * pW;
  QRadioButton * radio;
  QCheckBox * check;
  QLineEdit * lineEdit;
  QMultiLineEdit * edit;
  QPushButton * pushButton;
  QWidget * box; /* listbox && combobox */
  QSpinBox * spinBox;
  KRule * source; /* for container */

  /* attributes for treeview */
  QWidgetStack * stack;
  QListView * listView;
  QListViewItem * item;
  QPtrDict<KPlace> * myDict;
  bool hasFriendPlace;
  KPlace * friendPlace; /* pW is the widget holding friendPlace */

  /* pointer to the rule for subdialog and for the subdialog itself*/
  KRule * buttonchild;
  QDialog * subdialog;

  /* original listing not in the listbox */
  QStringList myList;

  /* indicates that it's a multicolumn list */
  bool isMultiCol;

  /* the appropriate rule */
  KRule * rule;

  /* the dialog holding this place */
  QDialog * myDialog;

  QString buffer; /* for execbuffer */

  void clearAttributes();
 public:
  KPlace(KRule *, bool, bool, bool, bool, bool, QWidget *, QBoxLayout *,
         QObject *, QDialog *, bool, bool);
	KPlace(KRule *, QWidgetStack *, QListView *, QListViewItem *, KRule *,
	       QListViewItem *, QPtrDict<KPlace> *);
	~KPlace();
	
	QString copy();
	QString cut();
	void paste(QString);
	void replace(QString);
	
	QString evaluate();

	/* checkbox selection */
	bool isSelected();
	/* tristate selection */
	int getState();
	
 public slots:
  void selected();
  void selected(KPlace *);
  void contentChanged();
  void invokeChild();
  void addClicked();
  void removeClicked();
  void action();
  void getFile();
  void processExited(KProcess *);
  void pageSelected(QListViewItem *);
  void preview();
 signals:
  void clicked(KPlace *);
};

#endif
