#include <string>
#include <vector>
#include <iostream>
using namespace std;

#include "utility.h"
#include "category.h"
#include "globals.h"

#ifdef GUI
#include <qwidget.h>
#include <qlabel.h>
#include <qinputdialog.h>

#include "preferences.h"
#include "browser.h"

string wrapLabel( string s, int max, QWidget *parent )
{
	if( s == "" )
		return s;

	QLabel *label = new QLabel( parent );
	label->setMargin( 2 );
	label->setAlignment( QLabel::AlignCenter );

	vector<string> vec;
	dirToVec( s, vec, ' ', FALSE );

	// split at spaces before exceeding max length

	string midresult = vec[0];
	vector<string> result;

	for( unsigned int n = 1; n < vec.size(); n++ )
	{
		string test = midresult + " " + vec[n];
		
		label->setText( test.c_str() );
		if( label->sizeHint().width() > max )	
		{
			result.push_back( midresult );
			midresult = vec[n];
		}
		else
			midresult = test;
		
	}
	if( midresult != "" )
		result.push_back( midresult );	

	return vecToDir( result, "\n" );
}

int getInput( string &result, string msg )
{
	bool ok;

	QString text = QInputDialog::getText( "Parameter request", ( "Enter " + msg + ":" ).c_str(),\
											QLineEdit::Normal, s_input, &ok, browser, "Parameter request" );
	
	if( ok )
	{
		result = (const char *)(s_input = text);
		int i;
		while( ( i = result.find( " " ) ) != -1 )
			result[i] = '+';
	}
	
	return ok;
}

#endif

string showName( string name )
{
	int f = 0;
	while( ( f = name.find( "\\", f ) ) != -1 )
		name.erase( f++, 1 );
	
	return name;	
}

string fullPath( string path, Category *category )
{
        vector<string> dirv;

        while( category->parent != 0 )
        {
                dirv.push_back( category->name );
                category = category->parent;
        }

	string address = slashConcat( path, cFile );
        if( dirv.size() != 0 )
                for( int n = dirv.size()-1; n >= 0; n-- )
                        address += "/" + dirv[n];

	return address;
}

void dirToVec( string s, vector<string> &vec, char separator, int includeempty )
{
        vec.clear();

        int i;
        while( ( i = s.find_first_of( separator ) ) != -1 )
        {			
		if( ( trim( s.substr( 0, i ) ) != "" ) ||
		    includeempty )
                	vec.push_back( trim( s.substr( 0, i ) ) );
                s.erase( 0, i+1 );
        }
        if( ( trim( s ) != "" ) ||
	    includeempty )
                vec.push_back( trim( s ) );
}

string vecToDir( vector<string> &vec, string separator )
{
	return vecToDir( vec, 0, vec.size(), separator );
}

string vecToDir( vector<string> &vec, int startdir, int nrofdirs, string separator )
{
        vector<string> subv;
        string s;

        if( startdir >= vec.size() )
                return "";

        for( int n = startdir; n < startdir + nrofdirs; n++ )
                subv.push_back( vec[n] );

        for( unsigned int n = 0; n < subv.size(); n++ )
                s += separator + subv[n];
        s.erase( 0, 1 );

        return s;
}

int vecHasDii( vector<string> &vec )
{
	unsigned int n;
	return vecHasDii( vec, n );
}

int vecHasDii( vector<string> &vec, unsigned int &n )
{
        for( n = 0; n < vec.size(); n++ )
                if( ( vec[n].length() >= 5 ) &&
                    ( vec[n].rfind( ".dii" ) == vec[n].length()-4 ) )
                        return TRUE;

        return FALSE;
}

int vecHasDot( vector<string> &vec )
{
        for( unsigned int n = 0; n < vec.size(); n++ )
	{
		string name = vec[n];

		if( ( name == "." ) ||
		    ( name == ".." ) )
		    continue; 
		    
		int i;    
		while( ( i = name.find( "\\." ) ) != -1 )
			name.erase( i, 2 );
				
		if( name.find( "." ) != -1 )		
                        return TRUE;
	} 
	
        return FALSE;
}

int vectorContains( vector<string> &vec, string text, int inc )
{
	for( unsigned int n = 0; n < vec.size(); n += inc )
		if( vec[n] == text )
			return TRUE;

	return FALSE;
}

int equalCI( string a, string b )
{
	if( a.length() != b.length() )
		return FALSE;

        for( unsigned int i = 0; i < a.length(); i++ )
		if( a[i] != b[i] ) 
		{
			if( ( a[i] >= 'A' ) && ( a[i] <= 'Z' ) && 
			    ( b[i] == a[i] + 32 ) )
				continue; 

			if( ( b[i] >= 'A' ) && ( b[i] <= 'Z' ) && 
			    ( a[i] == b[i] + 32 ) )
				continue; 
			
			return FALSE;	
		}
	return TRUE;
}

int startsWithCI( string a, string b )
{
        if( a.length() < b.length() )
            return FALSE;

	return equalCI( a.substr( 0, b.length() ), b );	
}

string trim( string s )
{
        if( s.find_first_not_of( ' ' ) == -1 )
                return "";

        int i = s.find_first_not_of( ' ' );
        int j = s.find_last_not_of( ' ' );

        return s.substr( i, j-i+1 );
}

string rtrim( string s )
{
        return s.substr( 0, s.find_last_not_of( ' ' )+1 );
}

string itos( unsigned int i )
{
        string s;
        unsigned int deler = 1000000000;

        do
        {
                s += (char)(i/deler + '0');
                i = i % deler;
                deler = deler/10;
        }
        while( deler != 0 );

        while( s[0] == '0' )
                s.erase( 0, 1 );

        return s;
}

int stringtoi( string s )
{
	int i = 0;
	int mult = 1;
	int k = s.size()-1;
	while( k >= 0 )
	{
		i += mult * ( s[k]-'0' );
		mult *= 10;
		k--;
	}
	return i;
}

string ctos( char c )
{
	string s = " ";
	s[0] = c;
	return s;
}

string slashConcat( string a, string b )
{
	if( a == "" )
		return b;
	if( b == "" )
		return a;

        if( ( a[ a.length()-1 ] == '/' ) ||
            ( b[ 0 ] == '/' ) )
            return a + b;

        return a + "/" + b;
}

void printint( int nr, int max )
{
        if( max < 10 )
            cout << nr;
        else if( max < 100 )
        {
            if( nr < 10 )
               cout << "0" << nr;
            else
               cout << nr;
        }
        else if( max < 1000 )
        {
            if( nr < 10 )
                cout << "00" << nr;
            else if( nr < 100 )
                cout << "0" << nr;
            else
                cout << nr;
        }
}

string toUC( string s )
{
	for( unsigned int n = 0; n < s.length(); n++ )
		if( ( s[n] >= 'a' ) &&
		    ( s[n] <= 'z' ) )
		    s[n] = s[n] - ( 'a' - 'A' );
	return s;
}


