/***************************************************************************
                          batchiface.h  -  description
                             -------------------
    begin                : Sat Dec 27 23:54:28 CET 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BATCHIFACE_H
#define BATCHIFACE_H

#include <dcopobject.h>
#include <qstringlist.h>

class BatchIface : virtual public DCOPObject
{
    K_DCOP

    public:
    k_dcop:
        virtual void setCustomerId( const QString & id ) = 0;
        virtual void setLabelURL( const QString & url ) = 0;
        virtual void print( bool immediately = false, const QString & printer = QString::null ) = 0;

        virtual void loadFromFile( const QString & url ) = 0;
        virtual void loadFromClipboard() = 0;
        virtual bool addItem( const QString & article, const QString & group, int count = 1, bool msg = true ) = 0;
        virtual const QStringList allItems() = 0;
        virtual void images() = 0;

        virtual bool existsArticle( const QString & article ) = 0;
};

#endif /* BATCHIFACE_H */

