///////////////////////////////////////////////////////////////////////////////
// $Id: main.cpp,v 1.27 2001/02/13 20:26:59 pfeiffer Exp $	
// File  : main.cpp
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// This is the entry point to the program
///////////////////////////////////////////////////////////////////////////////
#include <stdlib.h>

#include "../config.h"
#include "kpackage.h"

#include <qfile.h>

#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <options.h>

#include <kaboutdata.h>

#include <kpTerm.h>
#include "debInterface.h"
#include "debAptInterface.h"
#include "debDpkgInterface.h"
#include "kissInterface.h"
#include "slackInterface.h"
#include "fbsdInterface.h"
#ifdef HAVE_RPM
#include "rpmInterface.h"
#endif


static const char *description = 
	I18N_NOOP("KDE Package installer");

static KCmdLineOptions options[] =
{
   { "remote ", I18N_NOOP("Remote host for Debian APT, via SSH"), 0 },
   { "r ", 0, 0},
   { "+[Package]", I18N_NOOP("Package to install"), 0 },
   { 0, 0, 0 }
};

// Global pointers
KPKG *kpkg;
KPACKAGE *kpackage;
kpPty *kpty;
kpRun *kprun;
kpRun *kpstart;
Opts *opts;

pkgInterface *kpinterface[kpinterfaceN];
 
int main(int argc, char **argv)
{
  KAboutData aboutData( "kpackage", I18N_NOOP("KPackage"), 
			  VERSION, description, KAboutData::License_GPL, 
			//    VERSION, description, 0, 
    "(c) 1999-2001, Toivo Pedaste");
  KCmdLineArgs::init( argc, argv, &aboutData );
  aboutData.addAuthor( "Toivo Pedaste",0, "toivo@ucs.uwa.edu.au");
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KApplication app;
  
  setenv("LC_ALL", KGlobal::locale()->language().latin1(), 1);

  kpkg = 0;
  int j = 0;

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  QString remoteHost = args->getOption("remote");
  kdDebug() << "r=" << args->getOption("remote") << "\n";

  kpty = new kpPty();
  kprun = new kpRun();
  kpstart = new kpRun();

  for (int i = 0; i < kpinterfaceN; i++) {
    kpinterface[i] = 0;
  }

  kpinterface[j++] = new DEBDPKG(remoteHost);
  kpinterface[j++] = new DEBAPT(remoteHost);
  kpinterface[j++] = new KISS(remoteHost);
#ifdef HAVE_RPM
  kpinterface[j++] = new RPM(remoteHost);
#endif
  kpinterface[j++] = new fbsdInterface(remoteHost);
  kpinterface[j++] = new SLACK(remoteHost); // Also catched BSD packages...

  opts = new Opts();

  if ( app.isRestored() ) {
    if (KPKG::canBeRestored(1)) {
      kpkg =  new KPKG(app.config());  
      kpkg->restore(1);
    }
  } else {
    // Create the main widget and show it
    kpkg = new KPKG(app.config());
    kpkg->show();
  }

  if (args->count()) {		// an argument has been given
      kpackage->openNetFile(args->url(0)); 
                        // install package from argument
  }  else {			// otherwise
    if (!kpkg->prop_restart)
      kpackage->setup();
    //        kpackage->setMode(KPACKAGE::Management, 0, 1); 
  }
  
  args->clear();

  int r = app.exec();		// execute the application

  // delete objects on exit
  delete kpkg;
  for (int i = 0; i < kpinterfaceN; i++) {
    delete kpinterface[i];
  }

  return r;			// return the result
}

