/***************************************************************************
 *   Copyright (C) 2004 by Alex Ibrado <alex@kdex.org>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KURLTABLEITEM_H_
#define _KURLTABLEITEM_H_

#include <qtable.h>
#include <qobject.h>
#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <kfile.h>

class KURLTableItem : public QTableItem
{
    public:
        KURLTableItem(QTable *table, const QString &text, const KURLCompletion::Mode cmode = KURLCompletion::FileCompletion, const KFile::Mode fmode = KFile::Files);
        KURLTableItem(QTable *table, EditType et, const QString &text);
        QWidget *createEditor() const;
        void setText(const QString &s);
        void setCompletionMode(const KURLCompletion::Mode cmode);
        void setContentFromEditor(QWidget *w);
        KURLRequester* urlRequester();
        int rtti();
        ~KURLTableItem();

    protected:
        KURLCompletion::Mode completionmode;
        unsigned int filemode;
        void init(const KURLCompletion::Mode cmode, const KFile::Mode fmode = KFile::Files);
        KURLRequester *kti;
};


#endif // _KURLTABLEITEM_H_
