/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KBLUEHANDLEPROCESS_H
#define KBLUEHANDLEPROCESS_H

// #define KDESKTOP_LOCK "kdesktop_lock"

#include <kprocess.h>

class KBlueLockHandleProcess : public QObject
{
  Q_OBJECT

public:
    KBlueLockHandleProcess();
    ~KBlueLockHandleProcess();
    static KBlueLockHandleProcess* getDefaultProcess(); // singleton

    void start();
    void terminate();
    void setParams(int force, int nolock);
    void setCallerName(QString appname);

public slots:
  void kdesktop_lock_terminated();

private:
  QString kdesktop_lock;
  QString caller_appname;
  static KBlueLockHandleProcess* _instance; // singleton pattern instance
  KProcess* proc;
};
#endif
