//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen <kdebluetooth@schaettgen.de>*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef HCILISTENER_H
#define HCILISTENER_H

#include <qobject.h>
#include <libkbluetooth/deviceaddress.h>

namespace KBluetooth {
    class HciSocket;
}

class HciListener : public QObject
{
Q_OBJECT
public:
    HciListener(QObject *parent);
    virtual ~HciListener();
    void start();
    
signals:
    void connectionStateChanged();
    void nameRequestComplete(int errorCode, KBluetooth::DeviceAddress addr, QString name);
    void inquiryStarted();
    void inquiryComplete(int errorCode);
    void inquiryResult(KBluetooth::DeviceAddress addr, int devClass);
    void connectionComplete(int status, KBluetooth::DeviceAddress addr);
    
private slots:
    void slotHciEvent(unsigned char eventCode, QByteArray buf);
    void slotHciConnectionClosed();
    void slotHciConnect();

private:
    KBluetooth::HciSocket *hciSocket;
};

#endif
