/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *   Derived from kinetd, (C) 2002 by Tim Jansen <tim@tjansen.de>
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef MOSTRECENTLYUSED_H
#define MOSTRECENTLYUSED_H

#include <qobject.h>
#include <dcopobject.h>
#include <deque>
#include <qstringlist.h>

/**
@author Fred Schaettgen
*/
class MostRecentlyUsed : public QObject, virtual public DCOPObject
{
    Q_OBJECT
    K_DCOP
k_dcop:
    void mruAdd(QString label, QStringList commandline, 
        QString iconname, QString deviceaddress);
    void mruClear();
    int getNumMru();
    QString getMruLabel(int n);
    QStringList getMruCommand(int n);
    QString getMruIcon(int n);
    QString getMruAddress(int n);
public:
    struct MruEntry {
        QString label;
        QStringList commandline;
        QString iconname;
        QString deviceaddress;
        bool operator==(const MruEntry& other) const;
    };
    std::deque<MruEntry> mruEntries;
    
    MostRecentlyUsed(QObject *parent);
    virtual ~MostRecentlyUsed();
    void writeConfig();
signals:
    void updateReceived();
};

#endif
