//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen <kdebluetooth@schaettgen.de>*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
 #ifndef NEIGHBOURMONITOR_H
#define NEIGHBOURMONITOR_H

#include <qobject.h>
#include <qtimer.h>
#include <qguardedptr.h>
#include <libkbluetooth/deviceaddress.h>
#include <deque>
#include <map>
#include <set>

class HciListener;
namespace KBluetooth {
    class HciSocket;
}

/**
@author Fred Schaettgen
*/
class NeighbourMonitor : public QObject
{
Q_OBJECT
public:
    struct NeighbourInfo {
        KBluetooth::DeviceAddress addr;
        int credits;
        bool nonDiscoverable;
    };    
    NeighbourMonitor(QObject *parent, HciListener* hciListener);
    ~NeighbourMonitor();
    void addPage(const KBluetooth::DeviceAddress& addr);
    void addInquiry();
    //std::set<KBluetooth::DeviceAddress> getDiscoverableNeighbourSet();
    //std::set<KBluetooth::DeviceAddress> getNondiscoverableNeighbourSet();    
    std::set<KBluetooth::DeviceAddress> getNeighbourSet();
    
signals:
    void neighboursChanged();

private:
    QGuardedPtr<HciListener> hciListener;
    std::map<KBluetooth::DeviceAddress, NeighbourInfo> neighbourMap;
    std::set<KBluetooth::DeviceAddress> inquiryResults;
    std::deque<KBluetooth::DeviceAddress> pageQueue;
    bool inquiryDue;
    const int initialCredits;
    QTimer *processTimeoutTimer;
    KBluetooth::HciSocket *hciSocket;
    bool executing;
        
private slots:
    void slotConnectionStateChanged();
    void slotNameRequestComplete(int errorCode, KBluetooth::DeviceAddress addr, QString name);
    void slotInquiryStarted();
    void slotInquiryComplete(int errorCode);
    void slotInquiryResult(KBluetooth::DeviceAddress addr, int devClass);
    void processQueue();
    void processTimeout();
};

#endif
