//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef SERVICETAB_H
#define SERVICETAB_H

#include "servicetabbase.h"
#include <qcstring.h>
#include <qdatastream.h>
#include <qstringlist.h>
#include <map>

class DCOPClient;

/**
@author Fred Schaettgen
*/
class ServiceTab : public ServiceTabBase
{
Q_OBJECT
public:
    ServiceTab(QWidget *parent, const char* name);
    ~ServiceTab();
    void apply();
    void defaults();
signals:
    void dirty();
private:
    QString getDocPath(QString serviceName);
    QString getDescription(QString serviceName);
    QStringList getResourceTypes(QString serviceName);
    QString getResource(QString serviceName, QString resourceType);
    QStringList getServiceList();
    bool canConfigure(QString serviceName);
    void configure(QString serviceName);
    bool isEnabled(QString serviceName);
    void update();
    void updateControls();
    void disableInterface(QString msg);
    bool getAuthentication(QString serviceName);
    bool getEncryption(QString serviceName);
    bool getMetaServerBoolValue(QString serviceName, QString function);
    void setMetaServerBoolValue(QString serviceName, 
        QString function, bool bVal);

    std::map<QString,bool> authenticateState;
    std::map<QString,bool> encryptState;
    DCOPClient *client;
    QStringList m_services;
private slots:
    void slotClickedHelpURL();
    void slotItemClicked();
    void slotEnableService();
    void slotDisableService();
    void slotSelectionChanged();
    void slotConfigure();
    void slotUpdate();
    void slotEncryptChanged();
    void slotAuthenticateChanged();
};

#endif
