/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "DeviceClass.h"
#include <stdio.h>

const char* DeviceClass::get_minors(int major) {
 printf("received major is: %d",major);
 switch (major) {
  case 0:  return "misc";
  case 1:  return CLASS_COMPUTER;
  case 2:  return CLASS_PHONE;
  case 3:  return CLASS_LAN_ACCESS;
  case 4:  return CLASS_AUDIO_VIDEO;
  case 5:  return CLASS_PERIPHERAL;
  case 6:  return CLASS_IMAGING;
  case 63: return "uncategorized";
  default: return ""; // just another brick in the -Wall
 }
}

const uint8_t* DeviceClass::get_minor_vals(int major, int* count = 0) {
 const uint8_t* tmp = 0;
 int cnt_tmp = 0;
 //int i=0;

 switch (major) {
  case 0:  tmp = NULL;cnt_tmp = 0;break;
  case 1:  tmp = class_computer_values;cnt_tmp = CLASS_COMPUTER_COUNT;break;
  case 2:  tmp = class_phone_values;cnt_tmp = CLASS_PHONE_COUNT;break;
  case 3:  tmp = class_lan_access_values;cnt_tmp = CLASS_LAN_ACCESS_COUNT;break;
  case 4:  tmp = class_audio_video_values;cnt_tmp=CLASS_AUDIO_VIDEO_COUNT;break;
  case 5:  tmp = class_peripheral_values;cnt_tmp = CLASS_PERIPHERAL_COUNT;break;
  case 6:  tmp = class_imaging_values;cnt_tmp = CLASS_IMAGING_COUNT;break;
  case 67: tmp = NULL;cnt_tmp = 0;break;
 }

 if (count!=0) {
   printf("*** count!=0 ***");fflush(stdout);
   *count = cnt_tmp;
   if (tmp != NULL) {
     printf("*** %d:%d ***\n",tmp[1],*count);
   } else {
     *count = 0;
   }
 }

 return tmp;
}

const uint8_t DeviceClass::get_minor_value(int major, int ord) {
  const uint8_t* values;
  uint8_t value = 0;
  values = DeviceClass::get_minor_vals(major);
  if (values != NULL) {
    printf("returning one of minors:\n");
    printf("first and second: %d, %d\n",values[0],values[1]);
    printf("values[%d]: %d\n",ord,values[ord]);
    value = values[ord];
  }
  return value;
}

const uint8_t DeviceClass::getServicesMask(int* services, int count) {
  uint8_t mask = 0;
  int i;
  for (i=0;i<count;i++) {
    mask |= (1 << services[i]);
    printf("and-ing with: %x\n",(1 << services[i]));
    printf("mask now: %x\n",mask);
  }
  printf("mask final: %x\n",mask);
  return mask;
}

/*void DeviceClass::xxx(uint8_t* d, const uint8_t* s) {
  d = (uint8_t*)malloc(sizeof(s));
  memcpy(d,s,sizeof(s));
}*/
