#include <qcstring.h>
#include <qsocket.h>
#include <qdatetime.h>
#include <qbitarray.h>

#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <kapp.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <klocale.h>
#include <kurl.h>
#include <ksock.h>

#include "|NAMELITTLE|.h"


using namespace KIO;
extern "C"
{
  int kdemain( int argc, char **argv )
  {
    KInstance instance( "kio_|NAMELITTLE|" );
    
    kdDebug(7101) << "*** Starting kio_|NAMELITTLE| " << endl;
    
    if (argc != 4)
      {
	kdDebug(7101) << "Usage: kio_|NAMELITTLE|  protocol domain-socket1 domain-socket2" << endl;
	exit(-1);
      }
    
    kio_|NAMELITTLE|Protocol slave(argv[2], argv[3]);
    slave.dispatchLoop();
    
    kdDebug(7101) << "*** kio_|NAMELITTLE| Done" << endl;
    return 0;
  }
} 

kio_|NAMELITTLE|Protocol::kio_|NAMELITTLE|Protocol(const QCString &pool_socket, const QCString &app_socket)
  : SlaveBase("kio_|NAMELITTLE|", pool_socket, app_socket)
{
 kdDebug() << "kio_|NAMELITTLE|Protocol::kio_|NAMELITTLE|Protocol()" << endl;
}
/* ---------------------------------------------------------------------------------- */


kio_|NAMELITTLE|Protocol::~kio_|NAMELITTLE|Protocol()
{
  kdDebug() << "kio_|NAMELITTLE|Protocol::~kio_|NAMELITTLE|Protocol()" << endl;
}


/* ---------------------------------------------------------------------------------- */
void kio_|NAMELITTLE|Protocol::get(const KURL& url )
{
  kdDebug() << "kio_|NAMELITTLE|::get(const KURL& url)" << endl ;

  kdDebug() << "Seconds: " << url.query() << endl;
  QString remoteServer = url.host();
  int remotePort = url.port();
  kdDebug() << "myURL: " << url.prettyURL() << endl;

  infoMessage(i18n("Looking for %1 ...").arg( remoteServer ) );
  QString theData = "This is a test of |NAME|";
  data(QCString(theData.local8Bit()));
  data(QByteArray());
  finished();
}

/* ---------------------------------------------------------------------------------- */


void kio_|NAMELITTLE|Protocol::mimetype(const KURL & /*url*/)
{
  mimeType("text/plain");
  finished();
}


/* --------------------------------------------------------------------------- */

