/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#ifndef __INDEXING_H__
#define __INDEXING_H__

#include <qcheckbox.h>
#include <klistview.h>
#include <kpushbutton.h>
#include <kcmodule.h>

class KCMBeagleIndexing : public KCModule
{
  Q_OBJECT

public:
  KCMBeagleIndexing(QWidget *parent=0, const char *name=0);
  ~KCMBeagleIndexing();

  virtual void load();
  virtual void load( bool useDefaults );
  virtual void save();
  virtual void defaults();

private slots:
    void slotAddSearch();
    void slotRemoveSearch();
    void slotSearchSelectionChanged(QListViewItem*);
    void slotAddPrivacy();
    void slotRemovePrivacy();
    void slotPrivacySelectionChanged(QListViewItem*);
    void changedValue();

private:
    QCheckBox *startBeagle;
    QCheckBox *indexOnBattery;
    QCheckBox *indexHome;
    KListView* index_list, *privacy_list;
    QPushButton* remove_index, *remove_privacy;

    void readIndexConfig(bool &indexHomeDir, bool &indexOnBattery, QStringList &roots, QStringList &excludeTypes, QStringList &excludeValues);
    bool saveIndexConfig(bool indexHomeDir, bool indexOnBattery, QStringList roots, QStringList excludeTypes, QStringList excludeValues);
};

#endif
