/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : 
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
 
#include "previewdlg.h"

#include <kurl.h>
#include <qimage.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qcursor.h>
#include <qwmatrix.h>
#include <kiconloader.h>


/*!
    \fn PreviewDlg::PreviewDlg()
 */
PreviewDlg::PreviewDlg(QWidget *parent, const char *name)
 : PreviewUI(parent, name)
{
    // Start with busy cursor
    setCursor(WaitCursor);
    
    // camera pic
    m_label->setPixmap(SmallIcon( "camera", KIcon::SizeHuge, KIcon::DefaultState ));
}

#include <kdebug.h>
/*!
    \fn PreviewDlg::~PreviewDlg()
 */
PreviewDlg::~PreviewDlg()
{
    kdDebug() << "here" << endl;
}


/*!
    \fn PreviewDlg::displayPhoto(const KURL &url, int rotation)
 */
void PreviewDlg::displayPhoto(const KURL &url, int rotation)
{
    QImage img(url.path());
    
    // rotatate the photo
    if( rotation != 0 )
    {
        QWMatrix matrix;
        matrix = matrix.rotate(rotation);
        img = img.xForm(matrix);
    }
    
    // size the photo
    img = img.smoothScale(520, 500, QImage::ScaleMin);
    
    // display the photo
    m_label->setPixmap(QPixmap(img));
    
    // Go back to standard cursor
    setCursor(ArrowCursor);
}


#include "previewdlg.moc"
