/* $Id: net.h 1014 2009-02-01 12:46:52Z ekalin $ */

/*
 * Copyright (C) 2004-2009 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */


#ifndef __NET_H
#define __NET_H


/**********************
 * Limits and defines *
 **********************/


/**************
 * Data types *
 **************/
struct resolve_data_s
{
  World           *world;
  gchar           *host;
  gchar           *port;
  int              ai_family;
  struct addrinfo *addrinfo;
  gboolean       (*callback)(gpointer);
  int              ret;
};


/*********************************
 * Function prototypes - general *
 *********************************/
gpointer resolve_name_thread(gpointer data);
gboolean continue_connecting_cb(gpointer data);
gboolean connected_to(World *world);


/*******************************
 * Function prototypes - proxy *
 *******************************/
void     proxy_info_free(proxy_settings *s);
void     proxy_info_copy(proxy_settings *source, proxy_settings *dest);
gboolean proxy_socks4_resolved_real_host_cb(gpointer data);
gboolean proxy_socks4_connected_to(World *world);
gboolean proxy_socks5_connected_to(World *world);




#endif
