/***************************************************************************
                                 knetload.h
                             -------------------                                         
    begin                : Mon Aug  9 14:30:56 GMT+1 1999
                                           
    copyright            : (C) 1999 by Markus Gustavsson                         
    email                : mighty@fragzone.se                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNETLOAD_H
#define KNETLOAD_H

#include "../version.h"

#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qtimer.h>
#include <qstring.h>

#include <kapp.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <dcopclient.h>
#include <ktmainwindow.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kstddirs.h>
#include <klocale.h>
#include <khelpmenu.h>

#include "proc.h"
#include "dock.h"
#include "popup.h"

class KNETLoad : public KTMainWindow {
	Q_OBJECT
public:

  KNETLoad(QWidget *parent = 0, const char *name = 0);
  ~KNETLoad();

private:

	QWidget *desk;

	Proc *proc;

	Dock *dockIn, *dockOut;

	KConfig *config;

	QTimer *t;

	PopUp *popup;

	QWidget *scaleInput, *scaleOutInput, *deviceInput;
	QPushButton *scaleBut, *scaleOutBut, *deviceBut;
	QPushButton *scaleButC, *scaleOutButC, *deviceButC;
	QLineEdit *scaleEdit, *scaleOutEdit, *deviceEdit;
	QLabel *scaleLabel, *scaleOutLabel, *deviceLabel;

	KHelpMenu *HelpMenu;

	QPopupMenu *Menu, *Diagram, *Speed, *ColorIn, *ColorOut, *Device, *Scale, *ScaleOut;

	QPixmap PixBlue, PixBlueOn;
	QPixmap PixGreen, PixGreenOn;
	QPixmap PixOrange, PixOrangeOn;
	QPixmap PixPurple, PixPurpleOn;
	QPixmap PixRed, PixRedOn;
	QPixmap PixTurquoise, PixTurquoiseOn;
	QPixmap PixYellow, PixYellowOn;

	QPixmap PixLines, PixLinesOn;
	QPixmap PixBars, PixBarsOn;
	QPixmap PixShaded, PixShadedOn;

	QPixmap Pixlo, PixloOn;
	QPixmap Pixeth0, Pixeth0On;
	QPixmap Pixippp0, Pixippp0On;
	QPixmap Pixppp0, Pixppp0On;
	QPixmap PixOther, PixOtherOn;

	QPixmap PixLabels, PixLabelsOn;
	QPixmap PixGrid, PixGridOn;
	QPixmap PixAct, PixActOn;
	QPixmap PixSoft, PixSoftOn;
	QPixmap PixColIn, PixColOut;
	QPixmap PixArrow, PixTrans;

	QPixmap PixQuit, PixAbout, PixHelp, PixDevice, PixScaling, PixSpeedArrow, PixStyle, PixClear;

	int colorIn, colorIdBlueIn, colorIdGreenIn, colorIdOrangeIn, colorIdPurpleIn, colorIdRedIn, colorIdTurquoiseIn, colorIdYellowIn;
	int colorOut, colorIdBlueOut, colorIdGreenOut, colorIdOrangeOut, colorIdPurpleOut, colorIdRedOut, colorIdTurquoiseOut, colorIdYellowOut;

	int speed, speedId100, speedId150, speedId200, speedId250, speedId300, speedId400, speedId600, speedId800;
	int speedId1000, speedId1200, speedId1500, speedId2000, speedId2500, speedId3000, speedId4000, speedId5000;

	int scale, scaleOut;

	int scaleId288K, scaleId336K, scaleId56K, scaleId64K, scaleId128K;
	int scaleId256K, scaleId512K, scaleId1M, scaleId2M, scaleId10M, scaleIduser;

	int scaleOutId288K, scaleOutId336K, scaleOutId56K, scaleOutId64K, scaleOutId128K;
	int scaleOutId256K, scaleOutId512K, scaleOutId1M, scaleOutId2M, scaleOutId10M, scaleOutIduser, scaleOutIdSame;

	int diagram, diagramIdLines, diagramIdBars, diagramIdShaded;

	int deviceIdlo, deviceIdeth0, deviceIdippp0, deviceIdppp0, deviceIduser;

	int menuIdGrid, menuIdActive, menuIdText, menuIdSoft;

	int deskX, deskY, popupX, popupY;

	bool grid, active, text, soft, popupOn;

	char *device, *tmp;

	float *nVal;

private slots:

	void activateMenu(QMouseEvent *);

	void setColIn(int);
	void setColBlueIn(void);
	void setColGreenIn(void);
	void setColOrangeIn(void);
	void setColPurpleIn(void);
	void setColRedIn(void);
	void setColTurquoiseIn(void);
	void setColYellowIn(void);

	void setColOut(int);
	void setColBlueOut(void);
	void setColGreenOut(void);
	void setColOrangeOut(void);
	void setColPurpleOut(void);
	void setColRedOut(void);
	void setColTurquoiseOut(void);
	void setColYellowOut(void);

	void setSpeed(int);
	void setSpeed100(void);
	void setSpeed150(void);
	void setSpeed200(void);
	void setSpeed250(void);
	void setSpeed300(void);
	void setSpeed400(void);
	void setSpeed600(void);
	void setSpeed800(void);
	void setSpeed1000(void);
	void setSpeed1200(void);
	void setSpeed1500(void);
	void setSpeed2000(void);
	void setSpeed2500(void);
	void setSpeed3000(void);
	void setSpeed4000(void);
	void setSpeed5000(void);

	void setScale(int);
	void setScale288K(void);
	void setScale336K(void);
	void setScale56K(void);
	void setScale64K(void);
	void setScale128K(void);
	void setScale256K(void);
	void setScale512K(void);
	void setScale1M(void);
	void setScale2M(void);
	void setScale10M(void);
	void setScaleuser(void);

	void setScaleOut(int);
	void setScaleOut288K(void);
	void setScaleOut336K(void);
	void setScaleOut56K(void);
	void setScaleOut64K(void);
	void setScaleOut128K(void);
	void setScaleOut256K(void);
	void setScaleOut512K(void);
	void setScaleOut1M(void);
	void setScaleOut2M(void);
	void setScaleOut10M(void);
	void setScaleOutuser(void);
	void setScaleOutSame(void);

	void setDiagram(int);
	void setDiagramLines(void);
	void setDiagramBars(void);
	void setDiagramShaded(void);

	void setDevice(const char *);
	void setDevicelo(void);
	void setDeviceeth0(void);
	void setDeviceippp0(void);
	void setDeviceppp0(void);
	void setDeviceuser(void);

	void clear(void);

	void setGrid(void);
	void setActive(void);
	void setText(void);
	void setSoft(void);

	void readScale(void);
	void readScaleOut(void);
	void readDevice(void);

	void cancelScale(void);
	void cancelScaleOut(void);
	void cancelDevice(void);

	void showPopUp(QPoint);
	void hidePopUp(void);
	void savePopUpPos(void);

	void step(void);

	void showHelp(void);
};

#endif




