/***************************************************************************
                                 main.cpp
                             -------------------                                         
    begin                : Mon Aug  9 14:30:56 GMT+1 1999
                                           
    copyright            : (C) 1999 by Markus Gustavsson                         
    email                : mighty@fragzone.se                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "knetload.h"

static const char *description = I18N_NOOP("Network loadmeter for Kicker, works with most devices.");
static const char *version = VERSION;

int main(int argc, char **argv)
{
	KAboutData aboutData("knetload", I18N_NOOP("KNETLoad"), version, description, KAboutData::License_GPL,
		"(c) 2000, Markus Gustavsson", "KNETLoad was first released on the 8'th Aug -99.",
		"http://kde.quakenet.eu.org", "mighty@fragzone.se");

	aboutData.addAuthor("Markus Gustavsson", "KNETLoad Developer", "mighty@fragzone.se");

	aboutData.addCredit("Njaard, Charles Samuels", "Support and help with KDE", "charles@kde.org");
	aboutData.addCredit("rikkus, Rik Hemsley", "Support and help with KDE", "rik@kde.org");
	aboutData.addCredit("Thanks to everyone in #KDE OpenProjects for being supportive and helpfull!");

	KCmdLineArgs::init(argc, argv, &aboutData);

	KApplication a;
  
	KNETLoad* knetload = 0;

	if(a.isRestored()) {
		if(KTMainWindow::canBeRestored(1))
			(new KNETLoad)->restore(1, 0);
	} else {
		knetload = new KNETLoad;
		a.setMainWidget(knetload);
	}

	if(!kapp->dcopClient()->isAttached())
		kapp->dcopClient()->attach();

	QByteArray params;
	QDataStream d(params, IO_WriteOnly);
	d << (int) getpid();

	kapp->dcopClient()->send("kicker", "TaskbarApplet", "clientDied(pid_t)", params);

	return a.exec();
}



