/* @(#) hash.c 1.2 @(#) */
/***************************************************************\
*	Copyright (c) 1999-00 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: HASH
*
*	Hash generation routines
\***************************************************************/

#define _KOALAMUD_HASH_C "@(#) nitehawk@localhost.1ststep.net|lib/koala/hash.c|20001015203354|63066 @(#)"

#include "autoconf.h"

#include "version.h"
#include "log.h"
#include "hash.h"

/* genhashfromstr
 *		Generate a hash value from the first strlen characters of str.
 *		Hash value is then divided by table size and the remainder is
 *			returned as the hash value.
 */
unsigned int genhashfromstr(char *str, int strlen, unsigned int tablesize)
{
	char *cur = str;
	unsigned total = 0;
	int pos = 1;
	
	while (pos <= strlen)
	{
		total = total + (pos * (*cur));
		cur++;
		pos++;
	}

	return 0;
}
