/*
	extras.h - Extras
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __EXTRAS_H__
#define __EXTRAS_H__

#include <qobject.h>
#include <qiconset.h>

class KPopupMenu;
class KPushButton;

#define ks_extras Extras::getInstance()

/** @short Extras - user commands stored in "extras" directory. */
class Extras: public QObject
{
	Q_OBJECT
public:
	/**
	 * Destructor.
	 */
	virtual ~Extras();

	/**
	 * Returns the @b Extras button.
	 */
	inline KPushButton *button() const { return _button; }

	/**
	 * Creates the @b Extras button.
	 * @param parent A parent widget
	 */
	void createButton(QWidget *parent);

	/**
	 * Executes an "extras" action previously selected from the menu.
	 * @return @c false if error; otherwise @c true
	 */
	bool execAction() const;

	/**
	 * Returns a file name which will be executed by @ref execAction.
	 */
	inline QString fileToExecute() const { return _fileToExecute; }

	/**
	 * Returns a full description of the action,
	 * or @c QString::null if no action.
	 */
	QString getActionDescription() const;

	/**
	 * Initializes and returns the instance of the "extras" manager.
	 */
	inline static Extras *getInstance()
	{
		if (!_instance)
			_instance = new Extras();

		return _instance;
	}
	
	void setAction(const QString &fileToExecute, const QString &description, QIconSet *icon = 0);
private:
	static Extras *_instance;
	KPopupMenu *_menu;
	KPushButton *_button;
	QMap<int, QString> *_idToFileMap;
	QString
		_description,
		_fileToExecute;
	Extras();

	/**
	 * Reads "extras" directory and creates menu items.
	 * @param parentMenu A parent menu
	 * @param subdir A subdirectory
	 */
	void buildMenu(KPopupMenu *parentMenu, const QString &subdir);

	bool execFile() const;
	QMap<int, QString> *getIdToFileMap();
public slots:
	/**
	 * Opens the "extras" directory in the @b Konqueror.
	 */
	void slotModify();
private slots:
	void slotActivated(int id);

	/**
	 * Called before the popup menu is displayed.
	 * All the menu items are initialized here.
	 */
	void slotShowMenu();
};

#endif // __EXTRAS_H__
