/* -------------------------- gnuMultiFile class --------------------------

   This class handles all operations related to the storage and retrieval of 
   multiple files and their options. These should be called from
   gnuInterface. 

   It is currently implemented with Qt's dictionary datastructure for keeping
   up with a list of plotFileOb's. 

   This file is part of Xgfe: X Windows GUI front end to Gnuplot
   Copyright (C) 1998 David Ishee

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ------------------------------------------------------------------------*/

#include "gnuMultiFile.h"

gnuMultiFile::gnuMultiFile()
{
  // create new filelist
  fileList = new QDict<gnuPlotFile>(101,TRUE); // max 100 elements
  fileList->setAutoDelete(TRUE); // autodelete members when removed

  // create new iterator
  fileListIterator = new QDictIterator<gnuPlotFile>(*fileList);
}

void gnuMultiFile::insertMultiFileNew(string filename)
{
  gnuPlotFile* thisFile = new gnuPlotFile; // create a new plotfile
    
  thisFile->setFilename(filename); // set filename of plotfile
  fileList->insert(filename.c_str(),thisFile); // insert into list

}

void gnuMultiFile::removeMultiFile(string filename)
{
  fileList->remove(filename.c_str());
}

void gnuMultiFile::setMultiFileDataSetStart(string filename, string start)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileDataSetStart(start);
}

string gnuMultiFile::getMultiFileDataSetStart(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileDataSetStart();
}

void gnuMultiFile::setMultiFileDataSetEnd(string filename,string end)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileDataSetEnd(end);
}

string gnuMultiFile::getMultiFileDataSetEnd(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileDataSetEnd();
}

void gnuMultiFile::setMultiFileDataSetIncrement(string filename,string inc)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileDataSetIncrement(inc);
}

string gnuMultiFile::getMultiFileDataSetIncrement(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileDataSetIncrement();
}

void gnuMultiFile::setMultiFileSampPointInc(string filename,string pinc)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileSampPointInc(pinc);
}

string gnuMultiFile::getMultiFileSampPointInc(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileSampPointInc();
}

void gnuMultiFile::setMultiFileSampLineInc(string filename,string linc)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileSampLineInc(linc);
}

string gnuMultiFile::getMultiFileSampLineInc(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileSampLineInc();
}

void gnuMultiFile::setMultiFileSampStartPoint(string filename,string startp)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileSampStartPoint(startp);
}

string gnuMultiFile::getMultiFileSampStartPoint(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileSampStartPoint();
}

void gnuMultiFile::setMultiFileSampStartLine(string filename,string startl)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileSampStartLine(startl);
}

string gnuMultiFile::getMultiFileSampStartLine(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileSampStartLine();
}

void gnuMultiFile::setMultiFileSampEndPoint(string filename,string endp)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileSampEndPoint(endp);
}

string gnuMultiFile::getMultiFileSampEndPoint(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileSampEndPoint();
}

void gnuMultiFile::setMultiFileSampEndLine(string filename,string endl)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileSampEndLine(endl);
}

string gnuMultiFile::getMultiFileSampEndLine(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileSampEndLine();
}

void gnuMultiFile::setMultiFileSmoothType(string filename,string type)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileSmoothType(type);
}

string gnuMultiFile::getMultiFileSmoothType(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileSmoothType();
}

void gnuMultiFile::insertMultiFileXColumnOption(string filename, string xcol)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileXColumn(xcol);
}

string gnuMultiFile::getMultiFileXColumnOption(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileXColumn();
}

void gnuMultiFile::insertMultiFileYColumnOption(string filename, string ycol)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileYColumn(ycol);
}

string gnuMultiFile::getMultiFileYColumnOption(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileYColumn();
}

void gnuMultiFile::insertMultiFileZColumnOption(string filename, string zcol)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileZColumn(zcol);
}

string gnuMultiFile::getMultiFileZColumnOption(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileZColumn();
}

void gnuMultiFile::insertMultiFileFormatOption(string filename, string format)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileFormatString(format);
}

string gnuMultiFile::getMultiFileFormatOption(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileFormatString();
}

void gnuMultiFile::insertMultiFileRawFormatOption(string filename, string format)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setRawFileFormatString(format);
}

string gnuMultiFile::getMultiFileRawFormatOption(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getRawFileFormatString();
}

void gnuMultiFile::setMultiFileStyleOption(string filename, string style)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileStyleType(style);
}

string gnuMultiFile::getMultiFileStyleOption(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileStyleType();
}

void gnuMultiFile::setMultiFileFilter(string filename, string filter)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileFilter(filter);
}

string gnuMultiFile::getMultiFileFilter(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileFilter();
}

void gnuMultiFile::setMultiFileFilterQuoteChar(string filename, string quote)
{
  tempFile = (*fileList)[filename.c_str()];
  tempFile->setFileFilterQuoteChar(quote);
}

string gnuMultiFile::getMultiFileFilterQuoteChar(string filename)
{
  tempFile = (*fileList)[filename.c_str()];
  return tempFile->getFileFilterQuoteChar();
}


string gnuMultiFile::getMultiFileFirstFilename()
{
  // set iterator to first element
  tempFile = fileListIterator->toFirst();

  // check for error (empty list = null)
  if (tempFile == 0)
    return "END";
  else
  {
    // get and return filename
    return tempFile->getFilename();
  }
}

string gnuMultiFile::getMultiFileFirstPlotCmd()
{
  // set iterator to first element
  tempFile = fileListIterator->toFirst();

  // check for error (empty list = null)
  if (tempFile == 0)
    return "END";
  else
  {
    // get and return plot command
    return tempFile->getPlotCmd();
  }
}

string gnuMultiFile::getMultiFileNextFilename()
{
  // increment filelist iterator
  tempFile = ++(*fileListIterator);
  
  // check for error (end of list = null)
  if (tempFile == 0)
    return "END";
  else
  {
    // get and return filename
    return tempFile->getFilename();
  }
}

string gnuMultiFile::getMultiFileNextPlotCmd()
{
  // increment filelist iterator
  tempFile = ++(*fileListIterator);
  
  // check for error (end of list = null)
  if (tempFile == 0)
    return "END";
  else
  {
    // get and return plot command
    return tempFile->getPlotCmd();
  }
}

void gnuMultiFile::setLegendTitle(string file, string title)
{
  tempFile = (*fileList)[file.c_str()];
  tempFile->setLegendTitle(title);
}

string gnuMultiFile::getLegendTitle(string file)
{
  tempFile = (*fileList)[file.c_str()];
  return tempFile->getLegendTitle();
}
