#! /bin/sh

set -e

if [ -z "$1" ]; then
	echo "Missing URL"
else
	if which netscape > /dev/null; then
		BROWSER=netscape
	elif which mozilla > /dev/null; then
		BROWSER=mozilla
	else
		echo "Could not find either Netscape or Mozilla"
		exit 0
	fi
	if ! $BROWSER -remote "openUrl($1)" 2> /dev/null; then
		echo "$BROWSER is not currently running. Starting a new instance..."
		$BROWSER "$1" &
	fi
fi
