#!/bin/bash



QTCONFIG=`which qtconfig`
QTMYDIR=`dirname $QTCONFIG`


if [ "x$QTDIR" = "x" ] ;
	then
	QTDIR="$QTMYDIR/../" ;
fi

if [ "x$KDEDIR" = "x" ] ;
	then
	KDEDIR=`kde-config --prefix` ;
fi

GCCCMDOBJ="gcc $CFLAGS $CXXFLAGS -I. -I$KDEDIR/include/ -I$QTDIR/include/ -I/usr/X11R6/include   -DQT_THREAD_SUPPORT  -D_REENTRANT -c -o"
GCCCMDEXE="gcc $CFLAGS $CXXFLAGS -I. -I$KDEDIR/include/ -I$QTDIR/include/ -I/usr/X11R6/include   -DQT_THREAD_SUPPORT  -D_REENTRANT -L$QTDIR/lib/ -L$KDEDIR/lib/ -lqt-mt -lkio  -o"
MOCSOURCES="kxdocker taskmanager xeconfiguration xeevents xematrix xeobject xeplugin_command xeplugin_dcop xeplugin_gapplet xeplugin_gapplet_interface xeplugin_gatrash xeplugin_gepager xeplugin_mouse xeplugin_gepillow xeplugin_gaclock xeplugin_taskmanager xeplugin_xmlconf xeroot xgicon xkbase xeplugin_gmounts xgdocker  xktray xeplugin_configurator xeplugin_animator"
BINTARGET="kxdocker"
CPPSOURCES="kxdocker main taskmanager xeconfiguration xeevents xematrix xeobject xeplugin_animator xeplugin_command xeplugin_configurator xeplugin_dcop xeplugin_gaclock xeplugin_gapplet xeplugin_gatrash xeplugin_gepager xeplugin_gepillow xeplugin_gmounts xeplugin_mouse xeplugin_taskmanager xeplugin_xmlconf xeroot xgdocker xgicon xkbase xktray"
SKELSOURCES="xeplugin_dcop"

# set -x
if ! [ "x$1" = "xnodialog" ] ;
	then
	USEDIALOG="yes"
	else
	shift
fi
list()
{
	for i in $MOCSOURCES; do
		echo $i
		done
	
	for i in $SKELSOURCES; do
		echo $i
		done
		
	for i in $CPPSOURCES; do
		echo $i
		done

}

if [ "x$1" = "xlist" ] ;
	then
	list
	exit 0
fi

ERRORTO="2>&1"

cleanup()
{
	rm -f *.so *.moc *.so
	rm -f $BINTARGET
}


compile()
{
	GAUGE=0
	
for i in $MOCSOURCES; do
	moc -o $i.moc  $i.h  ;
		if ! [ "x$USEDIALOG" = "x" ] ;
			then
		let GAUGE=$GAUGE+2;
		echo $GAUGE;
		fi 
	done

LINKSOURCE=""

for i in $SKELSOURCES; do
	dcopidl $i.h > $i.kidl  || ( rm -f $i.kidl ; false )  ;
	dcopidl2cpp --c++-suffix cpp --no-signals --no-stub $i.kidl  ;
	LINKSOURCE="$LINKSOURCE ${i}_skel.cpp" ;
		if ! [ "x$USEDIALOG" = "x" ] ;
			then
		let GAUGE=$GAUGE+1;
		echo $GAUGE;
		fi 
	done
	
for i in $CPPSOURCES; do
	$GCCCMDOBJ $i.o $i.cpp  ;
	if ! [ $? = 0 ] ;
		then
		exit 1;
	fi
		if ! [ "x$USEDIALOG" = "x" ] ;
			then
		let GAUGE=$GAUGE+2;
		echo $GAUGE;
		fi 
	LINKSOURCE="$LINKSOURCE $i.o" ;
	done

$GCCCMDEXE $BINTARGET $LINKSOURCE  
if ! [ "x$USEDIALOG" = "x" ] ;
	then
	echo "100";
fi

}


selected()
{

for i in $MOCSOURCES; do
	if [ "x$1" = "x$i" ] ;
	then
		moc -o $i.moc  $i.h;
		echo "x";
	fi
	done

for i in $SKELSOURCES; do
	LINKSOURCE="$LINKSOURCE ${i}_skel.cpp" ;
	if [ "x$1" = "x$i" ] ;
	then
		dcopidl $i.h > $i.kidl  || ( rm -f $i.kidl ; false );
		dcopidl2cpp --c++-suffix cpp --no-signals --no-stub $i.kidl;
		echo "x";
		shift
	fi
	done
	
for i in $CPPSOURCES; do
	LINKSOURCE="$LINKSOURCE $i.o" ;
	if [ "x$1" = "x$i" ] ;
	then
		$GCCCMDOBJ $i.o $i.cpp;
	
		if ! [ $? = 0 ] ;
			then
			exit 1;
		fi
		echo "x";
		shift
	fi
	done
if [ "x$1" = "x$BINTARGET" ] ;
	then
	$GCCCMDEXE $BINTARGET $LINKSOURCE
fi
}


CLEANUP=`selected $1 $2 $3 $4 $5 $6 $7`

if [ "x$CLEANUP" = "x" ] ;
	then
	cleanup
	else
	exit 0

fi

if ! [ "x$USEDIALOG" = "x" ] ;
	then
	compile | dialog --gauge "Compiling KXDocker" 10 70 1
else
	compile
fi




