/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GEPAGER_H
#define XEPLUGIN_GEPAGER_H

/*
#include <xeconfiguration.h>
#include <xeobject.h>
*/

#include <qwidget.h>
#include <qpixmap.h>
#include <qintdict.h>

#include <kwin.h>


class XSConfigurations;
class XGDocker;
class KRootPixmap;
class KWinModule;

/**
@author Stefano
*/
class XEPlugin_GEPager : public QWidget
{
Q_OBJECT
public:
    XEPlugin_GEPager(QWidget *parent = 0, const char *name = 0);

    ~XEPlugin_GEPager();
    void paintEvent( QPaintEvent *e);
    void xUpdate();
    void mouseReleaseEvent ( QMouseEvent * e );

private:
    QPixmap paintDesktop(int desk, int width, int height, bool curr=FALSE);
    KWin::WindowInfo* info( WId win );
    QIntDict<KWin::WindowInfo> windows;
    QColor bgcolor;
    int desktopPreview;
    WId active;

    protected:
	XSConfigurations *ActiveConfiguration;
	XGDocker	*xGDocker;
	QPixmap		vd[2];
	QPixmap		paintBuffer;
	QPixmap		pixmapBackground;
	KRootPixmap	*KDesktopBackground;
	KWinModule	*KDEWM;
	int lastDesktop;
	int nRows;

public slots:
    void xStop();
    void xSetup();
    void xStart();
    void xEventWidgetMoved(int x,int y,int x0, int y0, int x1,int y1);
    void backgroundUpdated(const QPixmap &);
    void currentDesktopChanged(int);
    void xEventDockerHidden();
    void xEventDockerShowed();
    void preview();
    void slotActiveWindowChanged( WId win );
	void slotWindowAdded( WId );
	void slotWindowRemoved( WId );
	void slotWindowChanged( WId, unsigned int );
	void slotStackingOrderChanged();
	void slotRefresh();
    void xGetParameter(const QString vname, QString&vvalue);
    void xSetupParameter(const QString vname, const QString vvalue);
    void xGetParameterList(QStringList *a);
};

#endif
