//LabPlot : GraphM.h

#ifndef GRAPHM_H
#define GRAPHM_H

#include <qtextstream.h>
#include <qprogressdialog.h>
#include "Graph.h"
#include "LRange.h"

class GraphM: public Graph
{
public:
	GraphM(QString n="", QString l="", LRange r[3]=0, LSource src=SFUNCTION, PType t=PSURFACE, Style *st=0, 
		Symbol *sy=0, double *a=0, int dimx=0, int dimy=0, bool s=true);
	~GraphM();
	GraphM *Clone();		// clone this graph
	double *Data() { return array; }
	void setData(double *data) { array = data; }
	QPixmap Pixmap();
	void setPixmap(QPixmap pm);
	int width() { return (int)range[0].rMax(); }
	int height() { return (int)range[1].rMax(); }
	void setWidth(int w) { range[0] = LRange(0,w); }
	void setHeight(int h) { range[1] = LRange(0,h); }
	LRange Range(int i) { return range[i]; }
	void setRange(LRange r[3]) { range[0]=r[0];range[1]=r[1];range[2]=r[2]; }
	void setZRange(LRange *r) { range[2]=*r; }	// only set z range (EditDialog)
	int NX() { return nx; }
	int NY() { return ny; }
	void setNumber(int NX,int NY) {nx=NX, ny=NY; }
	QStringList Info();
	void save(QTextStream *t, QProgressDialog *progress);
	void open(QTextStream *t, int version, QProgressDialog *progress);
	void saveXML(QDomDocument doc, QDomElement graphtag);
	void openXML(QDomNode node);
private:
	LRange range[3];
	int nx, ny;		//dimension
	double *array;
};

#endif // GRAPHM_H
